
package matprodalgorithms;

/**
 *
 * @author Michael Fouche
 */
public class MatMultNominal 
{
    // Matrix "A".
    private double[][] matA;
    // Matrix "B".
    private double[][] matB;
    // Product matrix.
    private double[][] matProd;
    
    private final int matSize;
    
    // Constructor
    /**
     *
     * @param matSize The user-specified n x n matrix size.
     */
    public MatMultNominal(int matSize)
    {
        this.matSize = matSize;
    }
    
    //--------------------------------------------------------------------------
    /**
     * This method builds the "A" and "B" matrix objects using 
     * the matrices passed through the argument.
     * 
     * @param matA The previously loaded (with new random numbers) "A" matrix.
     * @param matB The previously loaded (with new random numbers) "B" matrix.
     */
    public void loadMatrices(double[][] matA, double[][] matB)
    {
        this.matA = matA;
        this.matB = matB;
    }
    
    //--------------------------------------------------------------------------
    /**
     * This method performs the conventional matrix multiplication of the 
     * "A" and "B" matrices and returns the resultant product matrix.
     * 
     * @return The product matrix.
     */
    public double[][] multMatrices()
    {
        int i, j, k;
        
        // Build the product matrix.
        matProd = new double[matSize][matSize];
        
        // Perform the conventional matrix multiplication operation.
        for(i = 0; i < matSize; i++)
        {
            for(j = 0; j < matSize; j++)
            {
                for(k = 0; k < matSize; k++)
                {
                    matProd[i][j] += matA[i][k] * matB[k][j];
                }    
            }    
        }    

        return matProd;
    }
    

} // end of class MatMultNominal
