
package matprodalgorithms;

import com.mathworks.engine.EngineException;
import com.mathworks.engine.MatlabEngine;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;

/**
 *
 * @author Michael Fouche
 */
public class MatMultMatlabEng 
{
    // Matlab Engine object
    private MatlabEngine eng;
    
    // Matrix "A".
    private double[][] matA;
    // Matrix "B".
    private double[][] matB;
    // Product matrix.
    private double[][] matProd;
    
    // Constructor
    /**
     *
     */
    public MatMultMatlabEng()
    {
        // Activate the Matlab engine.
        launchMatlabEngine();
    }
    
    //--------------------------------------------------------------------------
    /**
     * This method computes the product of the two "A" and "B" matrices.
     * 
     * @return The resultant product matrix.
     */
    public double[][] getMatLabMatProd()
    {
        try
        {    
            // Load the 1st matrix ("A") to the Matlab workspace,
            // via the Matlab Engine.  Note that Matlab matrix name
            // does NOT have to be the same as the Java matrix name.
            eng.putVariable("matA", matA);
            // Load the 1st matrix ("B") to the Matlab workspace,
            // via the Matlab Engine.
            eng.putVariable("matB", matB);
            // Compute the product of the two matrices in the Matlab workspace.
            eng.eval("matProd = matA * matB;");
            // Retrieve the resultant matrix from the Matlab workspace.
            matProd = eng.getVariable("matProd");
        }
        catch(IllegalArgumentException | IllegalStateException 
                | InterruptedException | ExecutionException | 
                                                  RejectedExecutionException  e)
        {
            System.out.println("Error: "+e);
        }    
        
        return matProd;
    }
    
    //--------------------------------------------------------------------------
    /**
     * This method loads the "A" and "B" matrices.
     * 
     * @param matA The previously loaded (with new random numbers) "A" matrix.
     * @param matB The previously loaded (with new random numbers) "B" matrix.
     */
    public void loadMatrices(double[][] matA, double[][] matB)
    {
        this.matA = matA;
        this.matB = matB;
    }
    
    //--------------------------------------------------------------------------
    /**
     * This method activates / launches the Matlab engine (this must be done
     * before using the engine).
     * 
     */
    private void launchMatlabEngine()
    {
        try
        {
            eng = MatlabEngine.startMatlab();
        }
        catch(EngineException | IllegalArgumentException | IllegalStateException 
                                                       | InterruptedException e)
        {
            System.out.println("Exception: "+e);
        }   
    }
    
    //--------------------------------------------------------------------------
    /**
     * This method stops the Matlab engine - this should only be performed 
     * when the processing is complete.  It should remain active if continuous 
     * processing is performed - there's no point in having the lag associated 
     * with starting and stopping the Matlab Engine for each set of
     * matrix operations.
     * 
     */
    public void stopMatlabEngine()
    {
        try
        {
            // Shut down the Matlab Engine.
            eng.close();
        }
        catch(EngineException | IllegalArgumentException | 
                                        IllegalStateException e)
        {
            System.out.println("Exception: "+e);
        }   
    }
    

} // end of class MatMultMatlabEng
