
package matprodalgorithms;

import org.ejml.simple.SimpleMatrix;

/**
 *
 * @author Michael Fouche
 */
public class MatMultEJML 
{
    // EJML matrix "A".
    private SimpleMatrix ejmlMatA;
    // EJML matrix "B".
    private SimpleMatrix ejmlMatB;
    // EJML product matrix.
    private SimpleMatrix ejmlMatProd;
    // 2-D double product matrix.
    private final double[][] matOut;
    // Size of each matrix (n x n).
    private final int matSize;
    
    // Constructor
    /**
     *
     * @param matSize The user-specified n x n matrix size.
     */
    public MatMultEJML(int matSize)
    {
        // Set the matrix size.
        this.matSize = matSize;
        // Build the product matrix.
        this.matOut  = new double[matSize][matSize];
    }
    
    //--------------------------------------------------------------------------
    /**
     * This method builds the "A" and "B" SimpleMatrix objects using 
     * the matrices passed through the argument.
     * 
     * @param matA The previously loaded "A" matrix.
     * @param matB The previously loaded "B" matrix.
     */
    public void loadMatrices(double[][] matA, double[][] matB)
    {
        // Build and load the EJML matrix "A".
        this.ejmlMatA       = new SimpleMatrix(matA);
        // Build and load the EJML matrix "B".
        this.ejmlMatB       = new SimpleMatrix(matB);
    }

    //--------------------------------------------------------------------------
    /**
     * This method performs the EJML matrix multiplication of the "A" and
     * "B" matrices and returns the resultant product matrix.
     * 
     * @return The product matrix.
     */
    public double[][] multMatrices()
    {
        // Perform the EJML matrix multiplication operation.
        ejmlMatProd = ejmlMatA.mult(ejmlMatB);
                
        int i, j;
        
        // Load the EJML product matrix elements into the primitive 
        // product matrix.
        for(i = 0; i < matSize; i++)
        {
            for(j = 0; j < matSize; j++)
            {
                matOut[i][j] = ejmlMatProd.get(i, j);
            }    
        }    

        return matOut;
    }
    
    
} // end of class MatMultEJML
