
package matlabenginetest;

import java.util.concurrent.TimeUnit;

/**
 *
 * @author Michael Fouche
 */
public class TimerCheck 
{
    // Declare all objects and primitives.
    private long startTime;
    private long endTime;
    private long durationInNanoSec;
    private long durationInMilliSec;
    
    private String timerMsg;
    private String[] tMsg;
    private final String classMsg;
    
    //**************************************************************************
    // CONSTRUCTOR
    /**
     *
     * @param classMsg The application-specific header message (identifies 
     * the application).
     */
    public TimerCheck(String classMsg)
    {
        this.classMsg = classMsg;
    }
    //**************************************************************************

    //--------------------------------------------------------------------------
    /**
     * This method starts the timer.
     */
    public void startTimer()
    {
        // Start the timer.
        startTime = System.nanoTime();
        // Sets up the message structure.
        loadMessage();
    }
    
    //--------------------------------------------------------------------------
    /**
     * This method stops the timer and then builds the timer message.
     */
    public void stopTimer()
    {
        // Stop the timer.
        endTime = System.nanoTime();
        // Measure the elapsed time in Nanoseconds.
        durationInNanoSec = (endTime - startTime);
        // Convert to milliseconds.
        durationInMilliSec = TimeUnit.NANOSECONDS.toMillis(durationInNanoSec);
        // Build the complete timer message.  This String message is sent
        // out from the "retrieveTimerInfo" method.
        timerMsg = tMsg[0]+durationInMilliSec+tMsg[1];
    }
    
    //--------------------------------------------------------------------------
    /**
     * This method returns the String timer message (assembled in methods 
     * "loadMessage" and "stopTimer") which includes the elapsed time.
     * 
     * @return The complete timer message.
     */
    public String retrieveTimerInfo()
    {
        return timerMsg;
    }
    
    //--------------------------------------------------------------------------
    // This method assembles the timer message.
    private void loadMessage()
    {
        // Default timer message String array.
        tMsg = new String[2];
        // The application-specific name.
        tMsg[0] = classMsg+" elapsed time = ";
        tMsg[1] = " millisec";
    }
    
    //--------------------------------------------------------------------------
    /**
     * This method returns the elapsed time in milliseconds.
     * 
     * @return The elapsed time in milliseconds
     */
    public long getTime()
    {
        return durationInMilliSec;
    }  
    
} // end of class TimerCheck
