
package matlabenginetest;

import matprodalgorithms.MatMultEJML;
import matprodalgorithms.MatMultNominal;
import matprodalgorithms.MatMultMatlabEng;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

/**
 *
 * @author Michael Fouche
 */
public class MatlabEngineTest 
{
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) 
    {
        //**********************************************************************
        // DECLARE THE OBJECTS.
        // ArrayList holds the two matrices to be multiplied.
        ArrayList<double[][]> al;
        // Test file for debug information.
        FileWriter fw = null;
        // The object that builds and loads the two matrices 
        // with random numbers.
        MatBuild mb;
        
        // The object that performs the conventional approach for multiplying
        // two matrices.
        MatMultNominal mmn;
        // The object that performs matrix multiplication 
        // using the EJML algorithm.
        MatMultEJML ejmlMatrix;
        // The object that performs matrix multiplication 
        // using the Matlab algorithm.
        MatMultMatlabEng mmm;
        
        // Timer object for nominal multiplication algorithm.
        TimerCheck timerNom; 
        // Timer object for EJML multiplication algorithm.
        TimerCheck timerEJML;
        // Timer object for Matlab multiplication algorithm.
        TimerCheck timerMatlab;
        // Timer object for Matlab multiplication algorithm in prep phase. 
        TimerCheck timerMatlabPrep; 
        
        // 1st matrix to be multiplied.
        double[][] matA;
        // 2nd matrix to be multiplied.
        double[][] matB;

        // Result product matrix for conventional (nominal) algorithm.
        double[][] matProdNom;
        // Result product matrix for EJML algorithm.
        double[][] matProdEJML;
        // Result product matrix for Matlab algorithm.
        double[][] matProdMatlab;
        
        // For user to specify matrix size.
        int matSize;
        // For user to specify the number of Matlab prep runs.
        int numPrepRuns;
        // For user to specify the number of test runs.
        int numTestRuns;
        // For user to specify matrix element value to be displayed.
        int mXTest;
        int mYTest;
        
        // Run-time counter.
        int ctr;
        
        
        String dividerLine;
        String fileMsg;
        
        //**********************************************************************
        
        //**********************************************************************
        // USER SETTINGS
        
        // Size of each of the matrices - 
        // e.g., "1,000" is a 1,000 x 1,000 matrix.
        matSize = 1000; 

        // Number of "warm-up" Matlab runs.
        numPrepRuns = 20;
        // Number of test runs.
        numTestRuns = 20;
        
        // Matrix element values to show on the console output.
        mXTest = 314;  
        mYTest = 789;  

        //**********************************************************************

        //**********************************************************************
        // BUILD (INSTANTIATE) THE OBJECTS.
        al = new ArrayList<>();

        mb = new MatBuild(matSize);

        // Build the TimerCheck object - specifically for timing the Matlab 
        // operations, and build the Matlab matrix operations object - for
        // the prep phase.
        timerMatlabPrep = new TimerCheck("Matlab Warm-up: ");
        // Build the TimerCheck object - specifically for timing the Matlab 
        // operations, and build the Matlab matrix operations object - for
        // the test phase.
        timerMatlab = new TimerCheck("Matlab Matrix Multiplication: ");
        // Build the Matlab algorithm object.
        mmm = new MatMultMatlabEng();
        // Build the TimerCheck object - specifically for timing the 
        // conventional matrix operations.
        timerNom = new TimerCheck("Conventional Matrix Multiplication: ");
        // Build the conventional matrix multiplication object.
        mmn = new MatMultNominal(matSize);

        // Build the EJML matrix multiplication object.
        timerEJML = new TimerCheck("EJML Matrix Multiplication: ");
        // Build the EJML matrix multiplication object.
        ejmlMatrix = new MatMultEJML(matSize);

        //**********************************************************************
        // SET INITICAL CONDITIONS.
        
        dividerLine = 
               "------------------------------------------------------------\n";
        
        ctr = 1;

        
        fileMsg = " ";
        
        try
        {
            fw = new FileWriter("data.txt");
        }
        catch(IOException e)
        {
            System.out.println("File IO Error: "+e);
        }   
        
        //----------------------------------------------------------------------
        // Build, load (with random numbers), and retrieve the two matrices. 
        al = mb.getAandBMatrices();
        matA = al.get(0);
        matB = al.get(1);

        // Run the Matlab algorithm multiple times to allow it to optimize
        // the multiplication process.
        System.out.println("Prepping Matlab Engine ...\n");
        
        //**********************************************************************
        // MATLAB PREP RUNS.
        try
        {    
            for(int i = 0; i < numPrepRuns; i++)
            {
                // Build new matrices with random numbers.
                al = mb.getAandBMatrices();
                matA = al.get(0);
                matB = al.get(1);
                // Load the matrices into the Matlab class object.
                mmm.loadMatrices(matA, matB);
                // Start the timer.
                timerMatlabPrep.startTimer();
                // Request that the Matlab engine to multiply the two matrices
                // and return the resultant product matrix.
                matProdMatlab = mmm.getMatLabMatProd();
                // Stop the timer.
                timerMatlabPrep.stopTimer();
                
                // Output the timing information to the text file.
                fileMsg = String.valueOf(ctr)+", "+
                        String.valueOf(timerMatlabPrep.getTime())+", 0, 0"+"\n";
                fw.write(fileMsg);
                ctr++;
            }
        }
        catch(IOException e)
        {
            System.out.println("File-write error: "+e);
        }   
        
        System.out.println("Prepping Complete.\n");

        //**********************************************************************
        // MATRIX MULTIPLICATION TEST RUNS.
        for(int i = 0; i < numTestRuns; i++)
        {
            System.out.println(dividerLine);
            // Initialize the matA and matB matrices with new random numbers.
            // These will be process by the 3 matrix multiplication algorithms.
            al = mb.getAandBMatrices();
            matA = al.get(0);
            matB = al.get(1);

            //------------------------------------------------------------------
            // CONVENTIONAL MATRIX MULTIPLICATION.
            // Load the matrices.
            mmn.loadMatrices(matA, matB);

            // Start the timer for the conventional  matrix operation process.
            timerNom.startTimer();
            // Multiply the matrices and return the result.
            matProdNom = mmn.multMatrices();
            // Stop the timer.
            timerNom.stopTimer();
            // Output the information to the console window.
            System.out.println(timerNom.retrieveTimerInfo());
            System.out.println("==> Conventional Matrix["
                    +mXTest+"]["+mYTest+"] = "+matProdNom[mXTest][mYTest]);
            System.out.println("\n");

            //------------------------------------------------------------------
            // EJML MATRIX MULTIPLICATION.
            ejmlMatrix.loadMatrices(matA, matB);

            // Start the timer for the EJML matrix operation process.
            timerEJML.startTimer();
            // Multiply the matrices and return the result.
            matProdEJML = ejmlMatrix.multMatrices();
            // Stop the timer.
            timerEJML.stopTimer();
            // Output the information to the console window.
            System.out.println(timerEJML.retrieveTimerInfo());
            System.out.println("==> EJML Matrix["
                    +mXTest+"]["+mYTest+"] = "+matProdEJML[mXTest][mYTest]);
            System.out.println("\n");

            //------------------------------------------------------------------
            // MATLAB MATRIX MULTIPLICATION.
            // Load the matrices.
            mmm.loadMatrices(matA, matB);

            // Start the timer for the Matlab matrix operation process.
            timerMatlab.startTimer();
            // Multiply the matrices and return the result.
            matProdMatlab = mmm.getMatLabMatProd();
            // Stop the timer.
            timerMatlab.stopTimer();
            // Output the information to the console window.
            System.out.println(timerMatlab.retrieveTimerInfo());
            System.out.println("==> Matlab Matrix["
                    +mXTest+"]["+mYTest+"] = "+matProdMatlab[mXTest][mYTest]);
            System.out.println("\n");

            //------------------------------------------------------------------
            // Put together the file message.
            // The test number.
            String msg0 = String.valueOf(ctr);
            // The elapsed time for the Matlab algorithm.
            String msg1 = String.valueOf(timerMatlab.getTime());
            // The elapsed time for the EJML algorithm.
            String msg2 = String.valueOf(timerEJML.getTime());
            // The elapsed time for the conventional algorithm.
            String msg3 = String.valueOf(timerNom.getTime());
            // Assemble the individual messages into the final String message.
            fileMsg = msg0+", "+msg1+", "+msg2+", "+msg3+"\n";
            ctr++;
             
            // Write the String message to the text file.
            try
            {
                fw.write(fileMsg);
            }
            catch(IOException e)
            {
                System.out.println("IO Error: "+e);
            }    
        }
        
        //----------------------------------------------------------------------
        
        // Stop the Matlab engine.
        mmm.stopMatlabEngine();
        
        // Close the text file.
        try
        {
            fw.close();
        }
        catch(IOException e)
        {
            System.out.println("IO Error: "+e);
        }    
    }

    
} // end of class MatlabEngineTest 
