
package matlabenginetest;

import java.util.ArrayList;
import java.util.Random;

/**
 *
 * @author Michael Fouche
 */
public class MatBuild 
{
    private final Random randNum;
    
    private final double[][] matA;
    private final double[][] matB;
    
    private final int matSize;
    
    // Constructor
    /**
     *
     * @param matSize The user-specified n x n matrix size.
     */
    public MatBuild(int matSize)
    {
        this.matSize = matSize;
    
        randNum = new Random();
        
        matA    = new double[matSize][matSize];
        matB    = new double[matSize][matSize];
    }
    
    //--------------------------------------------------------------------------
    /**
     * This method loads both the "A" and "B" matrices with a new set of
     * random numbers.
     * 
     * @return The ArrayList that contains the two matrices which have been
     * loaded with random numbers.  
     */
    public ArrayList<double[][]> getAandBMatrices()
    {
        ArrayList<double[][]> al = new ArrayList<>();
        
        for( int i = 0; i < matSize; i++)
        {
            for( int j = 0; j < matSize; j++)
            {
                matA[i][j] = randNum.nextDouble();
                matB[i][j] = randNum.nextDouble();
            }    
        }    
        
        // Add the first matrix to the ArrayList object.
        al.add(matA);
        // Add the second matrix to the ArrayList object.
        al.add(matB);
        
        return al;
    }


} // end of class MatBuild
