/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util.event;

import com.mathworks.util.event.AWTKeyListener;
import com.mathworks.util.event.AWTMouseListener;
import com.mathworks.util.event.EventListenerList;
import com.mathworks.util.event.EventUtils;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public abstract class AbstractInputEventsDispatcher {
    protected final EventListenerList<AWTMouseListener> fAWTMouseListeners = EventListenerList.newEventListenerList(AWTMouseListener.class);
    protected final EventListenerList<AWTKeyListener> fAWTKeyListeners = EventListenerList.newEventListenerList(AWTKeyListener.class);
    protected AWTEventListener fAWTEventListener;
    private static final AbstractInputEventsDispatcher DEFAULT = new DefaultInputEventsDispatcher();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAWTMouseListener(AWTMouseListener aWTMouseListener) {
        EventListenerList<AWTMouseListener> eventListenerList = this.fAWTMouseListeners;
        synchronized (eventListenerList) {
            this.createAWTEventListener();
            this.fAWTMouseListeners.addListener(aWTMouseListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAWTKeyListener(AWTKeyListener aWTKeyListener) {
        EventListenerList<AWTMouseListener> eventListenerList = this.fAWTMouseListeners;
        synchronized (eventListenerList) {
            this.createAWTEventListener();
            this.fAWTKeyListeners.addListener(aWTKeyListener);
        }
    }

    protected void createAWTEventListener() {
        if (this.fAWTEventListener == null) {
            this.fAWTEventListener = new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent aWTEvent) {
                    if (aWTEvent instanceof KeyEvent) {
                        AbstractInputEventsDispatcher.this.dispatchKeyEvent((KeyEvent)aWTEvent);
                    } else {
                        AbstractInputEventsDispatcher.this.dispatchMouseEvent((MouseEvent)aWTEvent);
                    }
                }
            };
            EventUtils.addAWTEventListener(this.fAWTEventListener, 56L);
        }
    }

    protected abstract void dispatchKeyEvent(KeyEvent var1);

    protected void dispatchMouseEvent(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        Window window = null;
        Component component2 = null;
        if (component != null) {
            Window window2 = window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
            if (window != null) {
                component2 = SwingUtilities.getDeepestComponentAt(component, mouseEvent.getX(), mouseEvent.getY());
            }
        }
        this.fAWTMouseListeners.fire().mouseEventDispatched(mouseEvent, window, component2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAWTKeyListener(AWTKeyListener aWTKeyListener) {
        EventListenerList<AWTMouseListener> eventListenerList = this.fAWTMouseListeners;
        synchronized (eventListenerList) {
            this.fAWTKeyListeners.removeListener(aWTKeyListener);
            this.attempRemoveAWTListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAWTMouseListener(AWTMouseListener aWTMouseListener) {
        EventListenerList<AWTMouseListener> eventListenerList = this.fAWTMouseListeners;
        synchronized (eventListenerList) {
            this.fAWTMouseListeners.removeListener(aWTMouseListener);
            this.attempRemoveAWTListener();
        }
    }

    private void attempRemoveAWTListener() {
        if (this.fAWTMouseListeners.isEmpty() && this.fAWTKeyListeners.isEmpty()) {
            EventUtils.removeAWTEventListener(this.fAWTEventListener);
            this.fAWTEventListener = null;
        }
    }

    public static AbstractInputEventsDispatcher getDefault() {
        return DEFAULT;
    }

    private static class DefaultInputEventsDispatcher
    extends AbstractInputEventsDispatcher {
        private DefaultInputEventsDispatcher() {
        }

        @Override
        protected void dispatchKeyEvent(KeyEvent keyEvent) {
            Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            ((AWTKeyListener)this.fAWTKeyListeners.fire()).keyEventDispatched(keyEvent, window);
        }
    }
}

