/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util.async;

import com.mathworks.util.async.Callback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

public abstract class Status<T>
implements java.util.concurrent.Future {
    public abstract Status<T> on(Callback<T> var1);

    public abstract boolean isCompleted();

    public abstract boolean isFailed();

    public abstract boolean isSucceded();

    public T get() throws InterruptedException {
        return this.get(0L, TimeUnit.MILLISECONDS);
    }

    public T get(long l, TimeUnit timeUnit) throws InterruptedException {
        this.await(l, timeUnit);
        return this.getResult();
    }

    protected abstract T getResult();

    public boolean await(long l) throws InterruptedException {
        return this.await(l, TimeUnit.MILLISECONDS);
    }

    public abstract boolean await(long var1, TimeUnit var3) throws InterruptedException;

    public Status<T> assertSuccess() {
        try {
            if (!this.await(0L) || !this.isSucceded()) {
                throw new IllegalStateException("Status is not succeded");
            }
            return this;
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException(interruptedException);
        }
    }

    public Status<T> assertFailure() {
        try {
            if (!this.await(0L) || !this.isFailed()) {
                throw new IllegalStateException("Status is not failed");
            }
            return this;
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException(interruptedException);
        }
    }

    @Override
    public boolean cancel(boolean bl) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.isCompleted();
    }

    public static final class And
    extends BaseFuture<Object[]> {
        private final Status[] fStatuses;
        private int fCounter;

        public And(Collection<Status> collection) {
            this(collection.toArray(new Status[collection.size()]), 0);
        }

        public And(Status ... statusArray) {
            this((Status[])statusArray.clone(), 0);
        }

        private And(Status[] statusArray, int n) {
            this.fStatuses = statusArray;
            this.fCounter = n;
            Callback callback = new Callback(){

                public void success(Object object) {
                    this.completeIfDone(object);
                }

                public void fail(Object object) {
                    this.completeIfDone(object);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void completeIfDone(Object object) {
                    List list = null;
                    Object[] objectArray = null;
                    boolean bl = false;
                    And and = this;
                    synchronized (and) {
                        ((Object[])fArgOnCompletion)[((And)this).fCounter++] = object;
                        if (fCounter >= fStatuses.length) {
                            list = fList;
                            objectArray = (Object[])fArgOnCompletion;
                            bl = this.isSucceded();
                        }
                    }
                    if (list != null) {
                        if (bl) {
                            this.succedeList(list, objectArray);
                        } else {
                            this.failList(list, objectArray);
                        }
                    }
                }
            };
            this.fArgOnCompletion = new Object[statusArray.length];
            for (Status status : statusArray) {
                status.on(callback);
            }
        }

        public Status[] getStatuses() {
            return this.fStatuses;
        }

        @Override
        public synchronized boolean isCompleted() {
            for (Status status : this.fStatuses) {
                if (status.isCompleted()) continue;
                return false;
            }
            return true;
        }

        @Override
        public synchronized boolean isFailed() {
            for (Status status : this.fStatuses) {
                if (!status.isFailed()) continue;
                return true;
            }
            return false;
        }

        @Override
        public synchronized boolean isSucceded() {
            for (Status status : this.fStatuses) {
                if (status.isSucceded()) continue;
                return false;
            }
            return true;
        }
    }

    public static final class Future<T>
    extends BaseFuture<T> {
        private boolean isFailed;
        private boolean isSucceded;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void success(T t) {
            List list;
            Future future = this;
            synchronized (future) {
                if (this.isFailed || this.isSucceded) {
                    throw new IllegalStateException("Status has been already completed");
                }
                this.isSucceded = true;
                this.fArgOnCompletion = t;
                list = this.fList;
                this.notifyAll();
            }
            this.succedeList(list, t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fail(T t) {
            List list;
            Future future = this;
            synchronized (future) {
                if (this.isFailed || this.isSucceded) {
                    throw new IllegalStateException("Status has been already completed");
                }
                this.isFailed = true;
                this.fArgOnCompletion = t;
                list = this.fList;
                this.notifyAll();
            }
            this.failList(list, t);
        }

        @Override
        public synchronized boolean isCompleted() {
            return this.isSucceded || this.isFailed;
        }

        @Override
        public synchronized boolean isFailed() {
            return this.isFailed;
        }

        @Override
        public synchronized boolean isSucceded() {
            return this.isSucceded;
        }
    }

    public static abstract class BaseFuture<T>
    extends Status<T> {
        protected List<Callback<T>> fList;
        protected T fArgOnCompletion;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Status<T> on(Callback<T> callback) {
            T t;
            boolean bl;
            boolean bl2;
            BaseFuture baseFuture = this;
            synchronized (baseFuture) {
                bl2 = this.isFailed();
                bl = this.isSucceded();
                if (!bl2 && !bl) {
                    if (this.fList == null) {
                        this.fList = new ArrayList<Callback<T>>(4);
                    }
                    this.fList.add(callback);
                }
                t = this.fArgOnCompletion;
            }
            if (bl) {
                callback.complete(t);
                callback.success(t);
            } else if (bl2) {
                callback.complete(t);
                callback.fail(t);
            }
            return this;
        }

        @Override
        protected synchronized T getResult() {
            return this.fArgOnCompletion;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean await(long l, TimeUnit timeUnit) throws InterruptedException {
            boolean bl;
            BaseFuture baseFuture = this;
            synchronized (baseFuture) {
                bl = this.isCompleted();
                if (!bl) {
                    this.wait(timeUnit.toMillis(l));
                    bl = this.isCompleted();
                }
            }
            return bl;
        }

        protected void succedeList(List<Callback<T>> list, T t) {
            if (list != null) {
                for (Callback<T> callback : list) {
                    callback.complete(t);
                    callback.success(t);
                }
            }
        }

        protected void failList(List<Callback<T>> list, T t) {
            if (list != null) {
                for (Callback<T> callback : list) {
                    callback.complete(t);
                    callback.fail(t);
                }
            }
        }
    }

    public static final class Fail<T>
    extends Completed<T> {
        public Fail() {
        }

        public Fail(T t) {
            super(t);
        }

        @Override
        public Status<T> on(Callback<T> callback) {
            super.on(callback);
            callback.fail(this.fArg);
            return this;
        }

        @Override
        public boolean isFailed() {
            return true;
        }
    }

    public static final class Success<T>
    extends Completed<T> {
        public Success() {
        }

        public Success(T t) {
            super(t);
        }

        @Override
        public Status<T> on(Callback<T> callback) {
            super.on(callback);
            callback.success(this.fArg);
            return this;
        }

        @Override
        public boolean isSucceded() {
            return true;
        }
    }

    public static abstract class Completed<T>
    extends Status<T> {
        protected final T fArg;

        protected Completed() {
            this.fArg = null;
        }

        public Completed(T t) {
            this.fArg = t;
        }

        @Override
        public Status<T> on(Callback<T> callback) {
            callback.complete(this.fArg);
            return this;
        }

        @Override
        public boolean isCompleted() {
            return true;
        }

        @Override
        public boolean isFailed() {
            return false;
        }

        @Override
        public boolean isSucceded() {
            return false;
        }

        @Override
        protected T getResult() {
            return this.fArg;
        }

        @Override
        public boolean await(long l, TimeUnit timeUnit) throws InterruptedException {
            return true;
        }
    }
}

