/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public class StyledColor
extends Color {
    protected String fStyleName;
    protected final List<String> fAllowedStyles;
    protected boolean fIsColor;

    public StyledColor(double d, double d2, double d3, double d4, List<String> list) {
        super((float)d, (float)d2, (float)d3, (float)d4);
        if (list == null) {
            throw new IllegalArgumentException("Argument allowedStyles must not be null.");
        }
        this.fStyleName = null;
        this.fIsColor = true;
        this.fAllowedStyles = new ArrayList<String>(list);
    }

    public StyledColor(double d, double d2, double d3, List<String> list) {
        this(d, d2, d3, 1.0, list);
    }

    public StyledColor(String string, List<String> list) {
        super(0.0f, 0.0f, 0.0f);
        if (list == null) {
            throw new IllegalArgumentException("Argument allowedStyles must not be null.");
        }
        assert (list.contains(string)) : "styleName is not an allowed style: " + string;
        this.fStyleName = string;
        this.fIsColor = false;
        this.fAllowedStyles = new ArrayList<String>(list);
    }

    private static StyledColor newInstance(double d, double d2, double d3, double d4, String[] stringArray) {
        assert (stringArray != null) : "Argument allowedStyles must not be null";
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string : stringArray) {
            arrayList.add(string);
        }
        return new StyledColor(d, d2, d3, d4, arrayList);
    }

    private static StyledColor newInstance(String string, String[] stringArray) {
        assert (string != null) : "Argument style must not be null";
        assert (stringArray != null) : "Argument allowedStyles must not be null";
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string2 : stringArray) {
            arrayList.add(string2);
        }
        return new StyledColor(string, arrayList);
    }

    private double[] getComponents() {
        float[] fArray = this.getComponents(null);
        return new double[]{fArray[0], fArray[1], fArray[2], fArray[3]};
    }

    public boolean isStyle() {
        return !this.fIsColor;
    }

    public boolean isColor() {
        return this.fIsColor;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof StyledColor)) {
            return false;
        }
        StyledColor styledColor = (StyledColor)object;
        if (this.fIsColor != styledColor.fIsColor) {
            return false;
        }
        if (this.fIsColor) {
            return this.getRGB() == styledColor.getRGB();
        }
        return StringUtils.equalsIgnoreCase((String)this.fStyleName, (String)styledColor.fStyleName);
    }

    public String getStyleName() {
        return this.fStyleName;
    }

    public List<String> getAllowedStyles() {
        return Collections.unmodifiableList(this.fAllowedStyles);
    }

    public boolean isStyleAllowed(String string) {
        return this.getFullStyleName(string) != null;
    }

    public String getFullStyleName(String string) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        for (String string2 : this.fAllowedStyles) {
            if (!string2.toLowerCase().startsWith(string.toLowerCase())) continue;
            return string2;
        }
        return null;
    }

    @Override
    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("isColor", this.fIsColor);
        toStringBuilder.append("styleName", (Object)this.fStyleName);
        toStringBuilder.append("allowedStyles", (Object)this.fAllowedStyles.toString());
        double[] dArray = this.getComponents();
        toStringBuilder.append("r", dArray[0]).append("g", dArray[1]).append("b", dArray[2]).append("a", dArray[3]);
        toStringBuilder.append("color", (Object)super.toString());
        return toStringBuilder.toString();
    }
}

