/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import java.awt.GraphicsEnvironment;
import java.lang.reflect.Method;

public class ResolutionUtils {
    public static final int PLATFORM_DPI = PlatformInfo.isMacintosh() ? 72 : 96;
    public static final int DPI = !ResolutionUtils.isHighDPISupportEnabled() || GraphicsEnvironment.isHeadless() || PlatformInfo.isLinux() || PlatformInfo.getVersion() >= 10 ? PLATFORM_DPI : PlatformInfo.getVirtualScreenDPI();
    public static final int REFERENCE_DPI = Math.min(DPI, PLATFORM_DPI);
    private static double USER_SCALE_FACTOR = 1.0;

    public static boolean scalingEnabled() {
        return USER_SCALE_FACTOR > 1.0 || DPI != REFERENCE_DPI;
    }

    public static boolean performingUserSpecifiedScaling() {
        return USER_SCALE_FACTOR > 1.0;
    }

    public static double userSpecifiedScaleFactor() {
        return USER_SCALE_FACTOR;
    }

    public static int scaleSize(int n) {
        return (int)(USER_SCALE_FACTOR * (double)DPI * (double)n / (double)REFERENCE_DPI);
    }

    public static int unScaleSize(int n) {
        return (int)((double)(REFERENCE_DPI * n) / ((double)DPI * USER_SCALE_FACTOR));
    }

    private ResolutionUtils() {
    }

    private static boolean isHighDPISupportEnabled() {
        return NativeJava.nativeLibraryExists();
    }

    static {
        try {
            Class<?> clazz = Class.forName("com.mathworks.services.DisplayScaleFactorSetting");
            Method method = clazz.getMethod("getValue", new Class[0]);
            USER_SCALE_FACTOR = (Double)method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

