/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import com.mathworks.util.Combiner;
import com.mathworks.util.ExecutorServiceFactory;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class RequestAggregator<T extends Runnable> {
    private final Combiner<T, ? extends Runnable> fCombiner;
    private final boolean fAdaptive;
    private final Object fRequestLock;
    private final Object fExecuteLock;
    private final long fOriginalPeriodMilliseconds;
    private final Integer fSuspendRate;
    private long fPeriodMilliseconds;
    private long fLastExecuteTime;
    private int fLastRequestCount;
    private String fName;
    private List<T> fPendingRequests;
    private List<Runnable> fPendingIdleRequests;
    private ScheduledExecutorService fTimer;
    public static final int DEFAULT_PERIOD_MS = 100;

    public RequestAggregator() {
        this(new DefaultCombiner());
    }

    public RequestAggregator(Combiner<T, ? extends Runnable> combiner) {
        this(combiner, 100);
    }

    public RequestAggregator(int n) {
        this(new DefaultCombiner(), n);
    }

    public RequestAggregator(Combiner<T, ? extends Runnable> combiner, int n) {
        this(combiner, n, false);
    }

    public RequestAggregator(Combiner<T, ? extends Runnable> combiner, int n, boolean bl) {
        this(combiner, n, bl, null);
    }

    public RequestAggregator(Combiner<T, ? extends Runnable> defaultCombiner, int n, boolean bl, Integer n2) {
        this.fSuspendRate = n2;
        this.fCombiner = defaultCombiner == null ? new DefaultCombiner() : defaultCombiner;
        this.fPeriodMilliseconds = n;
        this.fAdaptive = bl;
        this.fRequestLock = new Object();
        this.fExecuteLock = new Object();
        this.fPendingRequests = new LinkedList<T>();
        this.fPendingIdleRequests = new Vector<Runnable>();
        this.fOriginalPeriodMilliseconds = n;
        if (this.fAdaptive) {
            this.fPeriodMilliseconds = 0L;
        }
    }

    public void setName(String string) {
        this.fName = string;
    }

    public String getName() {
        return this.fName;
    }

    public void waitForPendingRequests() {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        this.runWhenIdle(new Runnable(){

            @Override
            public void run() {
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException(interruptedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWhenIdle(Runnable runnable) {
        Object object = this.fRequestLock;
        synchronized (object) {
            this.fPendingIdleRequests.add(runnable);
            this.request(null);
        }
    }

    private void recordExecutionAndAdapt() {
        if (this.fAdaptive) {
            boolean bl;
            long l = System.currentTimeMillis();
            boolean bl2 = bl = (double)(l - this.fLastExecuteTime) < (double)Math.max(50L, this.fPeriodMilliseconds) * 1.5;
            if (bl) {
                this.fPeriodMilliseconds = (int)Math.max(10.0, (double)this.fPeriodMilliseconds * 1.5);
                this.fPeriodMilliseconds = Math.min(this.fPeriodMilliseconds, this.fOriginalPeriodMilliseconds * 8L);
            } else {
                this.fPeriodMilliseconds = 0L;
            }
            this.fLastExecuteTime = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelPendingRequests() {
        Object object = this.fRequestLock;
        synchronized (object) {
            this.fPendingRequests.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(T t) {
        Object object = this.fRequestLock;
        synchronized (object) {
            if (t != null) {
                this.fPendingRequests.add(t);
            }
            if (this.fTimer == null) {
                String string = this.fName == null ? "Unnamed RequestAggregator Timer" : this.fName;
                this.fTimer = ExecutorServiceFactory.createScheduledExecutorService(string, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = RequestAggregator.this.fExecuteLock;
                        synchronized (object) {
                            Vector vector;
                            long l = RequestAggregator.this.fLastExecuteTime;
                            RequestAggregator.this.recordExecutionAndAdapt();
                            if (RequestAggregator.this.fSuspendRate != null) {
                                vector = RequestAggregator.this.fRequestLock;
                                synchronized (vector) {
                                    long l2 = System.currentTimeMillis() - l;
                                    long l3 = RequestAggregator.this.fPendingRequests.size() - RequestAggregator.this.fLastRequestCount;
                                    RequestAggregator.this.fLastRequestCount = RequestAggregator.this.fPendingRequests.size();
                                    if (l > 0L && l2 > 0L && l3 > 0L && l3 * 1000L / l2 >= (long)RequestAggregator.this.fSuspendRate.intValue()) {
                                        return;
                                    }
                                }
                            }
                            Vector vector2 = RequestAggregator.this.fRequestLock;
                            synchronized (vector2) {
                                vector = new Vector(RequestAggregator.this.fPendingRequests);
                                RequestAggregator.this.fPendingRequests.clear();
                                if (RequestAggregator.this.fPendingRequests.isEmpty()) {
                                    RequestAggregator.this.fTimer.shutdown();
                                    RequestAggregator.this.fTimer = null;
                                }
                            }
                            if (!vector.isEmpty()) {
                                vector2 = (Runnable)RequestAggregator.this.fCombiner.combine(vector);
                                vector2.run();
                            }
                            Iterator iterator = RequestAggregator.this.fRequestLock;
                            synchronized (iterator) {
                                if (RequestAggregator.this.fTimer == null) {
                                    vector2 = new Vector(RequestAggregator.this.fPendingIdleRequests);
                                    RequestAggregator.this.fPendingIdleRequests.clear();
                                } else {
                                    vector2 = new Vector();
                                }
                            }
                            for (Runnable runnable : vector2) {
                                runnable.run();
                            }
                        }
                    }
                }, Math.max(1L, this.fPeriodMilliseconds), TimeUnit.MILLISECONDS);
            }
        }
    }

    private static class DefaultCombiner<T extends Runnable>
    implements Combiner<T, Runnable> {
        private DefaultCombiner() {
        }

        @Override
        public Runnable combine(final List<T> list) {
            return new Runnable(){

                @Override
                public void run() {
                    long l = System.currentTimeMillis();
                    for (Runnable runnable : list) {
                        long l2 = System.currentTimeMillis() - l;
                        if (l2 - l > 150L) {
                            l = l2;
                            Thread.yield();
                        }
                        runnable.run();
                    }
                }
            };
        }
    }
}

