/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.Predicate;
import com.mathworks.util.ReturnRunnable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Semaphore;

public final class ObjectPool<T> {
    private final List<Entry> fObjects;
    private final ReturnRunnable<T> fGenerator;
    private final Predicate<T> fFilter;
    private final ParameterRunnable<T> fDisposer;
    private Integer fIndefiniteCount;
    private boolean fDisposed;

    public ObjectPool(Class<T> clazz) {
        this(clazz, null);
    }

    public ObjectPool(final Class<T> clazz, Integer n) {
        this(new ReturnRunnable<T>(){

            @Override
            public T run() {
                try {
                    return clazz.newInstance();
                }
                catch (Exception exception) {
                    throw new IllegalStateException(exception);
                }
            }
        }, null, null, n);
    }

    public ObjectPool(ReturnRunnable<T> returnRunnable) {
        this(returnRunnable, null, null, null);
    }

    public ObjectPool(ReturnRunnable<T> returnRunnable, Integer n) {
        this(returnRunnable, null, null, n);
    }

    public ObjectPool(ReturnRunnable<T> returnRunnable, Predicate<T> predicate, ParameterRunnable<T> parameterRunnable, Integer n) {
        this.fGenerator = returnRunnable;
        this.fObjects = new ArrayList<Entry>();
        this.fIndefiniteCount = n;
        this.fDisposer = parameterRunnable != null ? parameterRunnable : new ParameterRunnable<T>(){

            @Override
            public void run(T t) {
            }
        };
        this.fFilter = predicate != null ? predicate : new Predicate<T>(){

            @Override
            public boolean accept(T t) {
                return true;
            }
        };
    }

    public synchronized void dispose() {
        this.fDisposed = true;
        this.flush();
    }

    public synchronized void flush() {
        Iterator<Entry> iterator = this.fObjects.iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
            iterator.remove();
        }
    }

    public void withObject(ParameterRunnable<T> parameterRunnable) {
        T t = this.acquire();
        try {
            parameterRunnable.run(t);
        }
        finally {
            this.release(t);
        }
    }

    public synchronized T acquire() {
        for (Entry entry : this.fObjects) {
            if (!entry.tryAcquire()) continue;
            if (this.fFilter.accept(entry.getObject())) {
                return entry.getObject();
            }
            entry.release();
        }
        Entry entry = new Entry(this.fGenerator.run());
        if (!entry.tryAcquire() || !this.fFilter.accept(entry.getObject())) {
            throw new IllegalStateException();
        }
        this.fObjects.add(entry);
        return entry.getObject();
    }

    public synchronized void release(T t) {
        for (Entry entry : this.fObjects) {
            if (entry.getObject() != t) continue;
            entry.release();
            break;
        }
        Iterator<Entry> iterator = this.fObjects.iterator();
        while ((this.fIndefiniteCount == null || this.fObjects.size() > this.fIndefiniteCount || this.fDisposed) && iterator.hasNext()) {
            Entry entry;
            entry = iterator.next();
            if (!entry.tryAcquire()) continue;
            iterator.remove();
            entry.dispose();
        }
    }

    public int size() {
        return this.fObjects.size();
    }

    private final class Entry {
        private final T fObject;
        private final Semaphore fLock;

        Entry(T t) {
            this.fObject = t;
            this.fLock = new Semaphore(1);
        }

        boolean tryAcquire() {
            return this.fLock.tryAcquire();
        }

        T getObject() {
            return this.fObject;
        }

        void release() {
            this.fLock.release();
        }

        void dispose() {
            this.release();
            ObjectPool.this.fDisposer.run(this.fObject);
        }
    }
}

