/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import com.mathworks.util.FactoryUtils;
import com.mathworks.util.Log;
import com.mathworks.util.ManifestAttributeProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.commons.io.FilenameUtils;

public final class ManifestAttributeProviderImpl
implements ManifestAttributeProvider {
    private static final String MATHWORKS_BUNDLE_ATTRIBUTE = "MathWorks-Bundle";
    private final Map<String, Collection<String>> fAttributes = new HashMap<String, Collection<String>>();

    @Override
    public Collection<String> getBundleAttributeValue(String string) {
        return !this.fAttributes.containsKey(string) ? Collections.emptyList() : this.fAttributes.get(string);
    }

    public ManifestAttributeProviderImpl() {
        this.loadMathWorksBundleAttributes();
    }

    private void loadMathWorksBundleAttributes() {
        Collection<File> collection = ManifestAttributeProviderImpl.getJarFiles();
        for (File file : collection) {
            Map<String, Collection<String>> map = ManifestAttributeProviderImpl.getMathWorksAttributesFromJarFile(file);
            this.addAttributes(map);
        }
    }

    private void addAttributes(Map<String, Collection<String>> map) {
        for (String string : map.keySet()) {
            if (!this.fAttributes.containsKey(string)) {
                this.fAttributes.put(string, new ArrayList());
            }
            this.fAttributes.get(string).addAll(map.get(string));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, Collection<String>> getMathWorksAttributesFromJarFile(File file) {
        try (JarInputStream jarInputStream = new JarInputStream(new FileInputStream(file));){
            Manifest manifest = jarInputStream.getManifest();
            if (manifest == null) return Collections.emptyMap();
            Attributes attributes = manifest.getMainAttributes();
            if (!"true".equals(attributes.getValue(MATHWORKS_BUNDLE_ATTRIBUTE))) {
                Map<String, Collection<String>> map = Collections.emptyMap();
                return map;
            }
            Map<String, Collection<String>> map = ManifestAttributeProviderImpl.getMathWorksAttributes(attributes);
            return map;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return Collections.emptyMap();
        }
        catch (IOException iOException) {
            Log.printLn("Error reading manifest: " + file.getName());
            Log.logException(iOException);
        }
        return Collections.emptyMap();
    }

    private static Map<String, Collection<String>> getMathWorksAttributes(Attributes attributes) {
        HashMap<String, Collection<String>> hashMap = new HashMap<String, Collection<String>>();
        Set<Object> set = attributes.keySet();
        for (Object e : set) {
            String string = e.toString();
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, new ArrayList());
            }
            ((Collection)hashMap.get(string)).add(attributes.getValue(string));
        }
        return hashMap;
    }

    private static Collection<File> getJarFiles() {
        String string = FactoryUtils.getMatlabStaticClasspath();
        String[] stringArray = string.split(File.pathSeparator);
        HashSet<File> hashSet = new HashSet<File>();
        for (String string2 : stringArray) {
            if (string2.endsWith("\\")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (!FilenameUtils.isExtension((String)string2, (String)"jar")) continue;
            hashSet.add(new File(string2));
        }
        return hashSet;
    }
}

