/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LanguageUtils {
    private static final boolean IS_JAPANESE = Locale.getDefault().getLanguage().equals(Locale.JAPANESE.getLanguage());
    private static final boolean IS_KOREAN = Locale.getDefault().getLanguage().equals(Locale.KOREAN.getLanguage());
    private static final boolean IS_ENGLISH = Locale.getDefault().getLanguage().equals(Locale.ENGLISH.getLanguage());
    private static final boolean IS_CHINESE = Locale.getDefault().getLanguage().equals(Locale.CHINESE.getLanguage());

    public static boolean isJapanese() {
        return IS_JAPANESE;
    }

    public static boolean isEnglish() {
        return IS_ENGLISH;
    }

    public static boolean isKorean() {
        return IS_KOREAN;
    }

    public static boolean isChinese() {
        return IS_CHINESE;
    }

    public static boolean isCJK() {
        return LanguageUtils.isJapanese() || LanguageUtils.isKorean() || LanguageUtils.isChinese();
    }

    public static Locale createLocaleForLangLocaleString(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        Pattern pattern = Pattern.compile("(^.*)[_](.*$)");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            return new Locale(matcher.group(1), matcher.group(2));
        }
        return new Locale(string);
    }

    private LanguageUtils() {
    }
}

