/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import com.mathworks.util.Log;

public class IntBuffer {
    public static final int INCREMENT_MODE = 0;
    public static final int MODULO_INCREMENT_MODE = 1;
    public static final int DOUBLE_MODE = 2;
    public static final int DOUBLING_MODE = 3;
    public static final int QUAD_MODE = 4;
    private int[] fBuf;
    private int fLength;
    private int fIncrement;
    private int fGrowthFactor;
    private int fGrowthMode;
    private static final int NULL_VALUE = 0;
    private static final int[] EMPTY_ARRAY = new int[0];
    private final int[] fSingletonArray = new int[1];

    public IntBuffer() {
        this(16, 256);
    }

    public IntBuffer(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("InitialCapacity (" + n + ") must be > 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Increment (" + n2 + ") must be > 0");
        }
        this.fBuf = new int[n];
        this.fIncrement = n2;
        this.fLength = 0;
    }

    public int length() {
        return this.fLength;
    }

    public void setSize(int n) {
        this.setSize(n, true);
    }

    public void setSize(int n, boolean bl) {
        if (n < 0) {
            throw new IllegalArgumentException("newSize (" + n + ") must be >= 0");
        }
        if (n > this.fLength) {
            this.ensureCapacity(n);
        } else if (bl) {
            for (int i = n; i < this.fBuf.length; ++i) {
                this.fBuf[i] = 0;
            }
        }
        this.fLength = n;
    }

    public void ensureCapacity(int n) {
        if (n > this.fBuf.length) {
            int n2;
            if (this.fGrowthFactor > n) {
                n2 = this.fGrowthFactor;
            } else {
                switch (this.fGrowthMode) {
                    case 0: {
                        n2 = this.fBuf.length + this.fIncrement;
                        break;
                    }
                    case 1: {
                        n2 = (n + this.fIncrement - 1) / this.fIncrement * this.fIncrement;
                        break;
                    }
                    case 2: {
                        n2 = this.fBuf.length << 1;
                        if (n2 <= this.fIncrement) break;
                        n2 = (n + this.fIncrement - 1) / this.fIncrement * this.fIncrement;
                        break;
                    }
                    case 3: {
                        for (n2 = this.fBuf.length << 1; n > n2; n2 <<= 1) {
                        }
                        break;
                    }
                    case 4: {
                        n2 = this.fBuf.length << 2;
                        if (n2 <= this.fIncrement) break;
                        n2 = (n + this.fIncrement - 1) / this.fIncrement * this.fIncrement;
                        break;
                    }
                    default: {
                        n2 = 0;
                    }
                }
            }
            if (n > n2) {
                n2 = n + this.fIncrement;
            }
            int[] nArray = this.fBuf;
            this.fBuf = new int[n2];
            System.arraycopy(nArray, 0, this.fBuf, 0, nArray.length);
        }
    }

    public void setCapacityIncrement(int n) {
        if (n > 0) {
            this.fIncrement = n;
        }
    }

    public void setGrowthFactor(int n) {
        if (n >= 0) {
            this.fGrowthFactor = n;
        }
    }

    public void setGrowthMode(int n) {
        if (n >= 0 && n <= 4) {
            this.fGrowthMode = n;
        }
    }

    public void append(int n) {
        this.insert(this.fLength, n);
    }

    public void append(int[] nArray) {
        this.insert(this.fLength, nArray);
    }

    public void append(int[] nArray, int n) {
        this.replace(this.fLength, this.fLength, nArray, n);
    }

    public synchronized void insert(int n, int n2) {
        this.fSingletonArray[0] = n2;
        this.replace(n, n, this.fSingletonArray);
        this.fSingletonArray[0] = 0;
    }

    public void insert(int n, int[] nArray) {
        this.replace(n, n, nArray);
    }

    public void insertSpace(int n, int n2) {
        this.ensureCapacity(this.fLength + n2);
        System.arraycopy(this.fBuf, n, this.fBuf, n + n2, this.fLength - n);
        for (int i = 0; i < n2; ++i) {
            this.fBuf[n + i] = 0;
        }
        this.fLength += n2;
    }

    public void delete(int n, int n2) {
        this.replace(n, n2, EMPTY_ARRAY);
    }

    public void replace(int n, int n2, int n3) {
        this.fSingletonArray[0] = n3;
        this.replace(n, n2, this.fSingletonArray);
        this.fSingletonArray[0] = 0;
    }

    public void replace(int n, int n2, int[] nArray) {
        this.replace(n, n2, nArray, nArray.length);
    }

    private void replace(int n, int n2, int[] nArray, int n3) {
        this.checkRange(n, n2);
        if (nArray == null) {
            throw new IllegalArgumentException();
        }
        int n4 = n3 - (n2 - n);
        this.ensureCapacity(this.fLength + n4);
        System.arraycopy(this.fBuf, n2, this.fBuf, n2 + n4, this.fLength - n2);
        System.arraycopy(nArray, 0, this.fBuf, n, n3);
        if (n4 < 0) {
            for (int i = this.fLength + n4; i < this.fLength; ++i) {
                this.fBuf[i] = 0;
            }
        }
        this.fLength += n4;
    }

    public int getAt(int n) {
        this.checkIndex(n);
        return this.fBuf[n];
    }

    public void setAt(int n, int n2) {
        this.checkIndex(n);
        this.fBuf[n] = n2;
    }

    public void copyInto(int n, int n2, int[] nArray, int n3) {
        this.checkRange(n, n2);
        System.arraycopy(this.fBuf, n, nArray, n3, n2 - n);
    }

    public int[] getRawBuf() {
        return this.fBuf;
    }

    public int[] toArray() {
        int[] nArray = new int[this.length()];
        System.arraycopy(this.fBuf, 0, nArray, 0, nArray.length);
        return nArray;
    }

    private void checkRange(int n, int n2) {
        if (Log.LOGGING) {
            if (n > n2) {
                throw new IllegalArgumentException();
            }
            if (n != this.fLength) {
                this.checkHelper(n);
            }
            if (n2 != this.fLength) {
                this.checkHelper(n2);
            }
        }
    }

    private void checkIndex(int n) {
        if (Log.LOGGING) {
            this.checkHelper(n);
        }
    }

    private void checkHelper(int n) {
        if (n < 0 || n >= this.fLength) {
            throw new IllegalArgumentException("Invalid index (" + n + ") should be in the range [0," + this.fLength + "]");
        }
    }
}

