/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import com.mathworks.util.ImplementorsCache;
import com.mathworks.util.Log;
import com.mathworks.util.ManifestAttributeProviderFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ImplementorsCacheImpl
implements ImplementorsCache {
    private static final String SERVICES_ATTRIBUTE = "Services";
    private static final String PAIR_DELIMITER = ",";
    private static final String SERVICE_DELIMITER = ":";
    private final Map<Class, Collection<String>> fImplementors;
    private Map<String, Object> iImplementorToObject = new HashMap<String, Object>();

    public ImplementorsCacheImpl() {
        Collection<String> collection = ManifestAttributeProviderFactory.getInstance().getBundleAttributeValue(SERVICES_ATTRIBUTE);
        this.fImplementors = ImplementorsCacheImpl.getImplementorsForCache(collection);
    }

    @Override
    public <T> Collection<T> getImplementors(Class<T> clazz) {
        Collection<T> collection = null;
        if (this.fImplementors.containsKey(clazz)) {
            Collection<String> collection2 = this.fImplementors.get(clazz);
            try {
                collection = this.getServicesForImplementors(collection2, clazz);
            }
            catch (Exception exception) {
                Log.logException(exception);
            }
        }
        return collection == null ? Collections.emptyList() : collection;
    }

    private static Map<Class, Collection<String>> getImplementorsForCache(Collection<String> collection) {
        HashMap<Class, Collection<String>> hashMap = new HashMap<Class, Collection<String>>();
        if (collection == null || collection.isEmpty()) {
            return hashMap;
        }
        for (String string : collection) {
            for (String string2 : string.split(PAIR_DELIMITER)) {
                String string3 = "Manifest \"Services\" attribute incorrect; expected \"Services: interfaceName: className, interfaceName: className ...\"" + string2;
                if (!string2.contains(SERVICE_DELIMITER)) {
                    Log.log(string3);
                    continue;
                }
                String[] stringArray = string2.split(SERVICE_DELIMITER);
                if (stringArray.length != 2) {
                    Log.log(string3);
                    continue;
                }
                String string4 = stringArray[0].trim();
                String string5 = stringArray[1].trim();
                try {
                    Class<?> clazz = Class.forName(string4);
                    if (!clazz.isInterface()) {
                        Log.log("ImplementorsCacheImpl expected " + string4 + " in " + string2 + " to be an interface");
                        continue;
                    }
                    if (!hashMap.containsKey(clazz)) {
                        hashMap.put(clazz, new ArrayList());
                    }
                    ((Collection)hashMap.get(clazz)).add(string5);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return hashMap;
    }

    private <T> Collection<T> getServicesForImplementors(Collection<String> collection, Class<T> clazz) throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (String string : collection) {
            Object object = this.getService(string, clazz);
            arrayList.add(object);
        }
        return arrayList;
    }

    private <T> Object getService(String string, Class<T> clazz) throws Exception {
        if (this.iImplementorToObject.containsKey(string)) {
            return this.iImplementorToObject.get(string);
        }
        String string2 = clazz.getName();
        Object obj = Class.forName(string).newInstance();
        if (!clazz.isInstance(obj)) {
            Log.log("ImplementorsCacheImpl expected " + string + " to implement " + string2);
            obj = null;
        }
        this.iImplementorToObject.put(string, obj);
        return obj;
    }
}

