/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import com.mathworks.util.Log;
import com.mathworks.util.ResolutionUtils;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageInputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;

public class IconUtils {
    public static ImageIcon createScaledIcon(Icon icon, int n, int n2) {
        Image image;
        int n3 = icon.getIconWidth();
        int n4 = icon.getIconHeight();
        if (icon instanceof ImageIcon) {
            image = ((ImageIcon)icon).getImage();
        } else {
            image = new BufferedImage(n3, n4, 2);
            Graphics graphics = image.getGraphics();
            icon.paintIcon(new JLabel(), graphics, 0, 0);
            graphics.dispose();
        }
        return new ImageIcon(IconUtils.createScaledImage(image, n3, n4, n, n2));
    }

    public static Icon scaleForDPI(Icon icon) {
        if (ResolutionUtils.scalingEnabled()) {
            return IconUtils.createScaledIcon(icon, ResolutionUtils.scaleSize(icon.getIconWidth()), ResolutionUtils.scaleSize(icon.getIconHeight()));
        }
        return icon;
    }

    public static ImageIcon createScaledAnimatedIcon(URL uRL, int n, int n2) {
        try {
            ImageReader imageReader = ImageIO.getImageReadersBySuffix("gif").next();
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(uRL.openStream());
            imageReader.setInput(imageInputStream);
            File file = File.createTempFile("scaledIcon", ".gif");
            FileImageOutputStream fileImageOutputStream = new FileImageOutputStream(file);
            ImageWriter imageWriter = ImageIO.getImageWritersBySuffix("gif").next();
            ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
            imageWriter.setOutput(fileImageOutputStream);
            imageWriter.prepareWriteSequence(null);
            int n3 = imageReader.getNumImages(true);
            for (int i = 0; i < n3; ++i) {
                BufferedImage bufferedImage = imageReader.read(i);
                BufferedImage bufferedImage2 = IconUtils.createScaledImage(bufferedImage, bufferedImage.getWidth(), bufferedImage.getHeight(), n, n2);
                imageWriter.writeToSequence(new IIOImage(bufferedImage2, null, imageReader.getImageMetadata(i)), imageWriteParam);
            }
            imageInputStream.close();
            fileImageOutputStream.close();
            return new ImageIcon(file.getPath());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static boolean isAnimatedGif(URL uRL) {
        if (uRL.getFile().endsWith(".gif")) {
            try {
                ImageReader imageReader = ImageIO.getImageReadersBySuffix("gif").next();
                ImageInputStream imageInputStream = ImageIO.createImageInputStream(uRL.openStream());
                imageReader.setInput(imageInputStream);
                boolean bl = imageReader.getNumImages(true) > 1;
                imageInputStream.close();
                return bl;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    private static BufferedImage createScaledImage(Image image, int n, int n2, int n3, int n4) {
        BufferedImage bufferedImage = new BufferedImage(n3, n4, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(image, 0, 0, n3, n4, 0, 0, n, n2, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static ImageIcon createImageIconFromSVG(InputStream inputStream, int n, int n2) {
        TranscoderInput transcoderInput = new TranscoderInput(inputStream);
        ImageIconTranscoder imageIconTranscoder = new ImageIconTranscoder();
        imageIconTranscoder.addTranscodingHint(ImageTranscoder.KEY_WIDTH, Float.valueOf(n));
        imageIconTranscoder.addTranscodingHint(ImageTranscoder.KEY_HEIGHT, Float.valueOf(n2));
        ImageIconOutput imageIconOutput = new ImageIconOutput();
        try {
            imageIconTranscoder.transcode(transcoderInput, imageIconOutput);
            return imageIconOutput.getIcon();
        }
        catch (Exception exception) {
            Log.logException(exception);
            return null;
        }
    }

    private IconUtils() {
    }

    private static class ImageIconTranscoder
    extends ImageTranscoder {
        private ImageIconTranscoder() {
        }

        public BufferedImage createImage(int n, int n2) {
            return new BufferedImage(n, n2, 2);
        }

        public void writeImage(BufferedImage bufferedImage, TranscoderOutput transcoderOutput) throws TranscoderException {
            ImageIcon imageIcon = new ImageIcon(bufferedImage);
            if (transcoderOutput instanceof ImageIconOutput) {
                ((ImageIconOutput)transcoderOutput).setIcon(imageIcon);
            }
        }
    }

    private static class ImageIconOutput
    extends TranscoderOutput {
        private ImageIcon fIcon;

        private ImageIconOutput() {
        }

        private void setIcon(ImageIcon imageIcon) {
            this.fIcon = imageIcon;
        }

        private ImageIcon getIcon() {
            return this.fIcon;
        }
    }
}

