/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import com.mathworks.util.FactoryUtilSupplier;
import com.mathworks.util.MatlabThreadException;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;

public class FactoryUtils {
    private static FactoryUtilSupplier sDirSeed;
    private static FactoryUtilSupplier sProcessPendingEvents;
    private static FactoryUtilSupplier sProcessExposeEvents;
    private static FactoryUtilSupplier sProcessSynchronousSystemEvents;
    private static FactoryUtilSupplier sIsMatlabThread;
    private static FactoryUtilSupplier sInvokeAndWait;
    private static String sMatlabStaticClasspath;

    public static String getDirectorySeed() {
        String string = null;
        if (sDirSeed != null) {
            string = (String)sDirSeed.getValue();
        }
        if (string == null) {
            string = System.getProperty("user.dir");
        }
        return string;
    }

    public static String getMatlabStaticClasspath() {
        String string = null;
        if (sMatlabStaticClasspath != null) {
            string = sMatlabStaticClasspath;
        }
        if (string == null) {
            string = System.getProperty("java.class.path");
        }
        return string;
    }

    public static boolean processPendingEvents() {
        boolean bl = false;
        if (sProcessPendingEvents != null) {
            bl = sProcessPendingEvents.callBooleanMethod(null);
        }
        return bl;
    }

    public static boolean processExposeEvents() {
        boolean bl = false;
        if (sProcessExposeEvents != null) {
            bl = sProcessExposeEvents.callBooleanMethod(null);
        }
        return bl;
    }

    public static boolean processSynchronousSystemEvents() throws MatlabThreadException {
        Object object;
        if (sProcessSynchronousSystemEvents == null) {
            return false;
        }
        boolean bl = sProcessSynchronousSystemEvents.callBooleanMethod(null);
        if (!bl && (object = sProcessSynchronousSystemEvents.getValue()) != null) {
            assert (object instanceof String);
            if (object instanceof String) {
                throw new MatlabThreadException((String)object);
            }
        }
        return bl;
    }

    public static boolean isMatlabThread() {
        boolean bl = false;
        if (sIsMatlabThread != null) {
            bl = sIsMatlabThread.callBooleanMethod(null);
        }
        return bl;
    }

    public static void invokeAndWait(Runnable runnable) {
        if (sInvokeAndWait != null) {
            sInvokeAndWait.callVoidMethod(runnable);
        } else {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                assert (false);
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }

    public static void setDirectorySeed(FactoryUtilSupplier factoryUtilSupplier) {
        sDirSeed = factoryUtilSupplier;
    }

    public static FactoryUtilSupplier getDirectorySeedSupplier() {
        return sDirSeed;
    }

    public static void setProcessPendingEvents(FactoryUtilSupplier factoryUtilSupplier) {
        sProcessPendingEvents = factoryUtilSupplier;
    }

    public static void setProcessExposeEvents(FactoryUtilSupplier factoryUtilSupplier) {
        sProcessExposeEvents = factoryUtilSupplier;
    }

    public static void setProcessSynchronousSystemEvents(FactoryUtilSupplier factoryUtilSupplier) {
        sProcessSynchronousSystemEvents = factoryUtilSupplier;
    }

    public static void setIsMatlabThread(FactoryUtilSupplier factoryUtilSupplier) {
        sIsMatlabThread = factoryUtilSupplier;
    }

    public static void setInvokeAndWait(FactoryUtilSupplier factoryUtilSupplier) {
        sInvokeAndWait = factoryUtilSupplier;
    }

    public static void setMatlabStaticClasspath(String string) {
        sMatlabStaticClasspath = string;
    }
}

