/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import com.mathworks.util.event.GlobalEventListener;
import com.mathworks.util.event.GlobalEventManager;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public final class DeleteOnExitShutdownInitializer {
    private DeleteOnExitShutdownInitializer() {
    }

    public static synchronized void filterDeleteOnExitList() {
        Set<String> set = DeleteOnExitShutdownInitializer.getDeleteOnExitList();
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            File file = new File(iterator.next());
            if (file.isAbsolute()) continue;
            iterator.remove();
        }
    }

    public static Set<String> getDeleteOnExitList() {
        try {
            Class<?> clazz = Class.forName("java.io.DeleteOnExitHook");
            Field field = clazz.getDeclaredField("files");
            field.setAccessible(true);
            return (Set)field.get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            assert (false) : "Error in 'DeleteOnExitShutdownListener.getDeleteOnExitList'.  Possible compatibility issue from using reflection.  Exception: " + reflectiveOperationException.toString();
            return Collections.emptySet();
        }
    }

    static {
        GlobalEventManager.addListener("shutdown", new GlobalEventListener(){

            @Override
            public void actionPerformed(String string) {
                DeleteOnExitShutdownInitializer.filterDeleteOnExitList();
            }
        });
    }
}

