/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mvm.exec;

import com.mathworks.mvm.MVM;
import com.mathworks.mvm.MvmImpl;
import com.mathworks.mvm.MvmTerminatedException;
import com.mathworks.mvm.MvmWrapper;
import com.mathworks.mvm.exec.DequeueMode;
import com.mathworks.mvm.exec.FutureCallableResult;
import com.mathworks.mvm.exec.FutureEvalResult;
import com.mathworks.mvm.exec.FutureFevalResult;
import com.mathworks.mvm.exec.FutureResult;
import com.mathworks.mvm.exec.FutureRunnableResult;
import com.mathworks.mvm.exec.MatlabCallableRequest;
import com.mathworks.mvm.exec.MatlabEvalRequest;
import com.mathworks.mvm.exec.MatlabFevalRequest;
import com.mathworks.mvm.exec.MatlabIIP;
import com.mathworks.mvm.exec.MatlabRequest;
import com.mathworks.mvm.exec.MatlabRunnableRequest;
import com.mathworks.mvm.exec.NativeFutureResult;
import com.mathworks.util.ShutdownRuntimeException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class MatlabExecutor
extends AbstractExecutorService {
    private final MVM fMvm;

    public MatlabExecutor(MvmWrapper mvmWrapper) {
        this.fMvm = mvmWrapper.get();
    }

    public <V> FutureResult<V> submit(MatlabRequest<V> matlabRequest) throws RejectedExecutionException, ShutdownRuntimeException {
        return this.submit(matlabRequest, DequeueMode.PROMPT);
    }

    public <V> FutureResult<V> submit(MatlabRequest<V> matlabRequest, DequeueMode dequeueMode) throws RejectedExecutionException, ShutdownRuntimeException {
        return this.submit(matlabRequest, dequeueMode, null);
    }

    public <V> FutureResult<V> submit(MatlabRequest<V> matlabRequest, DequeueMode dequeueMode, String string) throws RejectedExecutionException, ShutdownRuntimeException {
        long l = this.fMvm.getHandle();
        if (0L == l) {
            Throwable throwable = new Throwable("MVM handle is unexpectedly 0. nativeSubmitIIP will assert.");
            throwable.fillInStackTrace();
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            throw new RejectedExecutionException(stringWriter.toString());
        }
        if (dequeueMode == DequeueMode.UNKNOWN) {
            throw new RejectedExecutionException("Invalid DequeueMode: " + dequeueMode.toString());
        }
        if (string != null && !string.isEmpty() && !string.matches("^[A-Za-z][A-Za-z0-9_]*$")) {
            throw new RejectedExecutionException("Invalid dequeue name. Name must be a legal MATLAB variable name: " + string);
        }
        MatlabIIP matlabIIP = matlabRequest.createIIP();
        NativeFutureResult<V> nativeFutureResult = this.nativeSubmitIIP(l, matlabIIP, dequeueMode.getValue(), string);
        if (nativeFutureResult == null) {
            if (this.fMvm.isTerminated()) {
                MvmTerminatedException mvmTerminatedException = new MvmTerminatedException();
                throw new RejectedExecutionException(mvmTerminatedException.getMessage(), mvmTerminatedException);
            }
            throw new RejectedExecutionException();
        }
        return matlabRequest.createFutureResult(nativeFutureResult);
    }

    public <V> FutureFevalResult<V> submit(MatlabFevalRequest<V> matlabFevalRequest) throws RejectedExecutionException {
        return (FutureFevalResult)this.submit((MatlabRequest<V>)matlabFevalRequest, DequeueMode.PROMPT);
    }

    public <V> FutureFevalResult<V> submit(MatlabFevalRequest<V> matlabFevalRequest, DequeueMode dequeueMode) throws RejectedExecutionException {
        return (FutureFevalResult)this.submit((MatlabRequest<V>)matlabFevalRequest, dequeueMode);
    }

    public <V> FutureFevalResult<V> submit(MatlabFevalRequest<V> matlabFevalRequest, DequeueMode dequeueMode, String string) throws RejectedExecutionException {
        return (FutureFevalResult)this.submit((MatlabRequest<V>)matlabFevalRequest, dequeueMode, string);
    }

    public FutureEvalResult submit(MatlabEvalRequest matlabEvalRequest) throws RejectedExecutionException {
        return (FutureEvalResult)this.submit((MatlabRequest)matlabEvalRequest, DequeueMode.PROMPT);
    }

    public FutureEvalResult submit(MatlabEvalRequest matlabEvalRequest, DequeueMode dequeueMode) throws RejectedExecutionException {
        return (FutureEvalResult)this.submit((MatlabRequest)matlabEvalRequest, dequeueMode);
    }

    public FutureEvalResult submit(MatlabEvalRequest matlabEvalRequest, DequeueMode dequeueMode, String string) throws RejectedExecutionException {
        return (FutureEvalResult)this.submit((MatlabRequest)matlabEvalRequest, dequeueMode, string);
    }

    public FutureRunnableResult submit(MatlabRunnableRequest matlabRunnableRequest) throws RejectedExecutionException {
        return (FutureRunnableResult)this.submit((MatlabRequest)matlabRunnableRequest, DequeueMode.PROMPT);
    }

    public FutureRunnableResult submit(MatlabRunnableRequest matlabRunnableRequest, DequeueMode dequeueMode) throws RejectedExecutionException {
        return (FutureRunnableResult)this.submit((MatlabRequest)matlabRunnableRequest, dequeueMode);
    }

    public FutureRunnableResult submit(MatlabRunnableRequest matlabRunnableRequest, DequeueMode dequeueMode, String string) throws RejectedExecutionException {
        return (FutureRunnableResult)this.submit((MatlabRequest)matlabRunnableRequest, dequeueMode, string);
    }

    public <V> FutureCallableResult<V> submit(MatlabCallableRequest<V> matlabCallableRequest) throws RejectedExecutionException {
        return (FutureCallableResult)this.submit((MatlabRequest<V>)matlabCallableRequest, DequeueMode.PROMPT);
    }

    public <V> FutureCallableResult<V> submit(MatlabCallableRequest<V> matlabCallableRequest, DequeueMode dequeueMode) throws RejectedExecutionException {
        return (FutureCallableResult)this.submit((MatlabRequest<V>)matlabCallableRequest, dequeueMode);
    }

    public <V> FutureCallableResult<V> submit(MatlabCallableRequest<V> matlabCallableRequest, DequeueMode dequeueMode, String string) throws RejectedExecutionException {
        return (FutureCallableResult)this.submit((MatlabRequest<V>)matlabCallableRequest, dequeueMode, string);
    }

    private native <V> NativeFutureResult<V> nativeSubmitIIP(long var1, MatlabIIP var3, long var4, String var6) throws RejectedExecutionException;

    @Override
    public void execute(@NotNull Runnable runnable) {
        throw new RejectedExecutionException();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return null;
    }

    @Override
    public boolean awaitTermination(long l, @NotNull TimeUnit timeUnit) {
        return true;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        throw new RejectedExecutionException();
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T t) {
        throw new RejectedExecutionException();
    }

    static {
        MvmImpl.loadLibrary();
    }
}

