/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mvm.eventmgr;

import com.mathworks.mvm.eventmgr.InsecureReflection;
import com.mathworks.mvm.eventmgr.InvalidEventTypeException;
import com.mathworks.mvm.eventmgr.MvmDynamicEvent;
import com.mathworks.mvm.eventmgr.MvmEvent;
import com.mathworks.mvm.eventmgr.MvmTypedEvent;
import java.lang.reflect.Method;

public class EventListening {
    private final Method fStaticEventType;
    private final Method fJavaEventFactory;
    private final Class<? extends MvmEvent> fClass;

    public <E> EventListening(Class<E> clazz) throws InvalidEventTypeException {
        this.fClass = clazz;
        this.fStaticEventType = EventListening.getEventTypeMethod(clazz);
        this.fJavaEventFactory = EventListening.getJavaEventFactory(clazz);
    }

    public EventListening() throws InvalidEventTypeException {
        this.fClass = MvmDynamicEvent.class;
        this.fStaticEventType = null;
        this.fJavaEventFactory = EventListening.getJavaEventFactory(MvmDynamicEvent.class);
    }

    public Class<? extends MvmEvent> getEventClass() {
        return this.fClass;
    }

    public String getStaticEventType() throws InvalidEventTypeException {
        try {
            return this.fStaticEventType.invoke(null, new Object[0]).toString();
        }
        catch (Throwable throwable) {
            assert (false) : throwable.toString();
            throw new InvalidEventTypeException(throwable);
        }
    }

    Method getJavaFactory() {
        return this.fJavaEventFactory;
    }

    private static Method getEventTypeMethod(Class<? extends MvmTypedEvent> clazz) throws InvalidEventTypeException {
        try {
            return InsecureReflection.getMethod(clazz, 9, "getStaticEventType", String.class, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InvalidEventTypeException("All MvmTypedEvent types require a static public method named getStaticEventType that returns the same string value as the C++ static method EventType() of the corresponding C++ type.", noSuchMethodException);
        }
    }

    private static Method getJavaEventFactory(Class<? extends MvmEvent> clazz) throws InvalidEventTypeException {
        try {
            return InsecureReflection.getMethod(clazz, 266, "nativeFactory", clazz, Long.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InvalidEventTypeException("All MvmEvent types require a static private native method named nativeFactory that returns " + clazz.toString() + " and has a long parameter.  The long is actually the C++ mlutil::eventmgr::BaseEvent const pointer used to construct the " + clazz.toString() + ".", noSuchMethodException);
        }
    }
}

