/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mvm.context;

import java.util.concurrent.Callable;

public class ThreadContext<T> {
    private final String fName;
    private final InheritableThreadLocal<T> fContext = new InheritableThreadLocal();

    ThreadContext(String string) {
        this.fName = string;
    }

    public void runWithContext(T t, final Runnable runnable) throws RuntimeException {
        try {
            this.callWithContext(t, new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    runnable.run();
                    return null;
                }
            });
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public T get() {
        return this.fContext.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R callWithContext(T t, Callable<R> callable) throws Exception {
        Object t2 = this.fContext.get();
        this.fContext.set(t);
        try {
            R r = callable.call();
            return r;
        }
        finally {
            this.fContext.set(t2);
        }
    }

    public String toString() {
        return this.fName;
    }
}

