/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mvm;

import com.mathworks.mvm.MvmFactory;
import com.mathworks.mvm.eventmgr.DefaultEventMgr;
import com.mathworks.mvm.eventmgr.EventMgr;
import com.mathworks.util.ShutdownRuntimeException;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class MvmSession
implements AutoCloseable {
    private static volatile EventMgr sEventMgr = null;
    @Nullable
    private final SessionOptions fOptions;
    private static volatile MvmSession sInstance = null;

    private MvmSession(@Nullable SessionOptions sessionOptions) {
        this.fOptions = sessionOptions;
    }

    @Nullable
    public static MvmSession getSession() throws ShutdownRuntimeException {
        if (!MvmFactory.nativeSessionExists()) {
            return null;
        }
        if (sInstance != null) {
            return sInstance;
        }
        return MvmSession.getInstance(null);
    }

    private static synchronized MvmSession getInstance(@Nullable SessionOptions sessionOptions) {
        if (sInstance == null) {
            sInstance = new MvmSession(sessionOptions);
        } else assert (sessionOptions == null);
        return sInstance;
    }

    public static synchronized MvmSession createSession(@Nullable SessionOptions sessionOptions) throws ShutdownRuntimeException, IllegalStateException {
        return MvmSession.createSession(sessionOptions, null);
    }

    public static synchronized MvmSession createSession(@Nullable SessionOptions sessionOptions, @Nullable MvmFactory.JavaLevel javaLevel) throws ShutdownRuntimeException, IllegalStateException {
        SessionOptions sessionOptions2 = sessionOptions == null ? new SessionOptions() : sessionOptions;
        boolean bl = MvmFactory.nativeStartSession(sessionOptions2.getPrimaryMode().getValue(), sessionOptions2.getSecondaryMode().getValue(), sessionOptions2.fLicense.getValue(), sessionOptions2.fDisableLocalMVM, sessionOptions2.getSessionArgs(), javaLevel == null ? MvmFactory.JavaLevel.Undefined.getValue() : javaLevel.getValue(), sessionOptions2.fThreadPoolSize);
        if (!bl) {
            throw new IllegalStateException("Session already created in " + (sInstance == null || sInstance.getOptions() == null ? "native code" : "Java"));
        }
        return MvmSession.getInstance(sessionOptions2);
    }

    @Override
    public void close() throws ShutdownRuntimeException {
        boolean bl = MvmFactory.nativeTerminateSession();
        assert (bl);
    }

    @Nullable
    public SessionOptions getOptions() {
        return this.fOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static EventMgr getDefaultEventMgr() {
        if (sEventMgr != null) return sEventMgr;
        Class<MvmSession> clazz = MvmSession.class;
        synchronized (MvmSession.class) {
            if (sEventMgr != null) return sEventMgr;
            sEventMgr = new DefaultEventMgr();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sEventMgr;
        }
    }

    public static EventMgr getEventMgr() {
        return MvmSession.getDefaultEventMgr();
    }

    public static void flushEvents() {
        MvmSession.getDefaultEventMgr().flush();
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (ShutdownRuntimeException shutdownRuntimeException) {
            // empty catch block
        }
        super.finalize();
    }

    public static class SessionOptions {
        private final PrimaryMode fPrimaryMode;
        private final SecondaryMode fSecondaryMode;
        @Nullable
        private final String[] fSessionArgs;
        private volatile int fHashCode = 0;
        public int fThreadPoolSize = 6;
        public boolean fDisableLocalMVM = false;
        public LicenseType fLicense = LicenseType.UndefinedLicense;

        public SessionOptions(@Nullable PrimaryMode primaryMode, @Nullable SecondaryMode secondaryMode, @Nullable String[] stringArray) {
            this.fSessionArgs = stringArray == null ? null : (String[])stringArray.clone();
            this.fPrimaryMode = primaryMode == null ? PrimaryMode.StandaloneContainer : primaryMode;
            this.fSecondaryMode = secondaryMode == null ? SecondaryMode.JavaBuilder : secondaryMode;
        }

        public SessionOptions(@Nullable String[] stringArray) {
            this(null, null, stringArray);
        }

        public SessionOptions() {
            this(null, null, null);
        }

        public boolean equals(Object object) {
            if (!(object instanceof SessionOptions)) {
                return false;
            }
            SessionOptions sessionOptions = (SessionOptions)object;
            return sessionOptions.hashCode() == this.hashCode() && this.fPrimaryMode == sessionOptions.getPrimaryMode() && this.fSecondaryMode == sessionOptions.getSecondaryMode() && this.fLicense == sessionOptions.fLicense && Arrays.equals(this.fSessionArgs, sessionOptions.getSessionArgs());
        }

        public int hashCode() {
            if (this.fHashCode == 0) {
                this.fHashCode = Arrays.hashCode(this.fSessionArgs) + this.fPrimaryMode.getValue() + this.fSecondaryMode.getValue();
            }
            return this.fHashCode;
        }

        @Nullable
        public String[] getSessionArgs() {
            return this.fSessionArgs == null ? null : (String[])this.fSessionArgs.clone();
        }

        public PrimaryMode getPrimaryMode() {
            return this.fPrimaryMode;
        }

        public SecondaryMode getSecondaryMode() {
            return this.fSecondaryMode;
        }

        public static enum LicenseType {
            UndefinedLicense(0),
            CommercialLicense(1),
            StudentLicense(2),
            StandaloneLicense(3),
            ScriptLicense(4),
            PolyspaceServer(5),
            PolyspaceDesktop(6),
            PolyspaceAccess(7),
            CommercialLicenseWarmupMode(8);

            private int fValue;

            private LicenseType(int n2) {
                this.fValue = n2;
            }

            int getValue() {
                return this.fValue;
            }
        }

        public static enum SecondaryMode {
            UndefinedSecondaryMode(0),
            ParallelWorker(1),
            Mcc(2),
            JavaBuilder(3),
            ParallelWorkerDesktop(4),
            JavaEngine(5),
            WebAppServer(6);

            private int fValue;

            private SecondaryMode(int n2) {
                this.fValue = n2;
            }

            int getValue() {
                return this.fValue;
            }
        }

        public static enum PrimaryMode {
            UndefinedPrimaryMode(0),
            Matlab(1),
            StandaloneApp(2),
            StandaloneContainer(3),
            StandaloneServer(4),
            Client(5);

            private int fValue;

            private PrimaryMode(int n2) {
                this.fValue = n2;
            }

            int getValue() {
                return this.fValue;
            }
        }
    }
}

