/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mvm;

import com.mathworks.capabilities.Capability;
import com.mathworks.capabilities.CapabilityList;
import com.mathworks.mvm.MVM;
import com.mathworks.mvm.MvmFactoryWrapper;
import com.mathworks.mvm.MvmImpl;
import com.mathworks.mvm.MvmTerminatedException;
import com.mathworks.mvm.eventmgr.DefaultEventMgr;
import com.mathworks.mvm.eventmgr.EventMgr;
import java.io.IOException;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Nullable;

public class MvmFactory {
    private final FactoryType fType;
    private final long fFactoryHandle;
    private static final Object LOCK = new Object();
    private static final long DEFAULT_INTERVAL_MSECS = 100L;
    private final String fFactoryName;
    private AtomicBoolean fTerminated = new AtomicBoolean();
    private final EventMgr fEventMgr;
    private static HashMap<Long, WeakReference<MVM>> sMvmMap = null;
    private static MvmFactory sLocalFactory = null;

    public FactoryType getType() {
        return this.fType;
    }

    public String getName() {
        return this.fFactoryName;
    }

    public EventMgr getEventMgr() {
        return this.fEventMgr;
    }

    public static MvmFactory createFactory(FactoryType factoryType, String string, @Nullable FactoryOptions factoryOptions) throws IllegalArgumentException, IllegalStateException, SecurityException, RuntimeException, InterruptedException {
        MvmFactory mvmFactory = null;
        try {
            mvmFactory = MvmFactory.createFactory(factoryType, string, factoryOptions, null, 0L);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        assert (mvmFactory != null);
        return mvmFactory;
    }

    public static MvmFactory createFactory(FactoryOptions factoryOptions, String string, long l) throws IllegalArgumentException, IllegalStateException, SecurityException, RuntimeException, InterruptedException, TimeoutException {
        return MvmFactory.createFactory(FactoryType.NETWORK, string, factoryOptions, null, l);
    }

    public static MvmFactory createFactory(FactoryOptions factoryOptions, String string, ExecOptions execOptions) throws IllegalArgumentException, IllegalStateException, SecurityException, RuntimeException, InterruptedException {
        MvmFactory mvmFactory = null;
        try {
            mvmFactory = MvmFactory.createFactory(FactoryType.MATLABMVM, string, factoryOptions, execOptions, 0L);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        assert (mvmFactory != null);
        return mvmFactory;
    }

    private MvmFactory(long l) {
        this.fFactoryHandle = l;
        this.fType = FactoryType.MATLABMVM;
        this.fFactoryName = "Java Engine";
        this.fEventMgr = new DefaultEventMgr(new MvmFactoryWrapper(this));
    }

    public static MvmFactory createEngineFactory(String[] stringArray) throws IllegalStateException, InterruptedException {
        long l = MvmFactory.nativeStartMatlabForEngine(stringArray);
        return new MvmFactory(l);
    }

    public static MvmFactory connectMatlab(String string) throws IllegalStateException {
        long l = MvmFactory.nativeConnectMatlabForEngine(string);
        return new MvmFactory(l);
    }

    public static String[] findMatlab() throws IllegalStateException {
        String[] stringArray = MvmFactory.nativeFindMatlabForEngine();
        return stringArray;
    }

    private static MvmFactory createFactory(FactoryType factoryType, @Nullable String string, @Nullable FactoryOptions factoryOptions, @Nullable ExecOptions execOptions, long l) throws IllegalArgumentException, IllegalStateException, SecurityException, RuntimeException, InterruptedException, TimeoutException {
        if (factoryType == FactoryType.LOCAL) {
            return MvmFactory.getLocalFactory();
        }
        return new MvmFactory(factoryType, string, factoryOptions, execOptions, l);
    }

    private MvmFactory(FactoryType factoryType, @Nullable String string, @Nullable FactoryOptions factoryOptions, @Nullable ExecOptions execOptions, long l) throws IllegalArgumentException, IllegalStateException, SecurityException, InterruptedException, TimeoutException, RuntimeException {
        this.fType = factoryType;
        if (factoryType == FactoryType.LOCAL) {
            assert (sLocalFactory == null && factoryOptions == null);
            this.fFactoryName = "local";
            this.fFactoryHandle = MvmFactory.nativeGetLocalFactory();
            if (this.fFactoryHandle == 0L) {
                throw new IllegalStateException("Local process does not support an MvmFactory");
            }
            this.fEventMgr = new DefaultEventMgr(new MvmFactoryWrapper(this));
            return;
        }
        this.fFactoryName = string;
        LinkedHashMap<String, String> linkedHashMap = execOptions == null ? null : (execOptions.getEnvironment() == null ? null : new LinkedHashMap<String, String>(execOptions.getEnvironment()));
        long l2 = MvmFactory.nativeCreateFactory(factoryType.getValue(), factoryOptions == null ? 0 : factoryOptions.getJavaLevel().getValue(), factoryOptions == null ? false : factoryOptions.isLayeredNetworkStackEnabled(), factoryOptions == null ? null : factoryOptions.toArray(), execOptions == null ? null : execOptions.getInstallDir(), execOptions == null ? null : execOptions.getUser(), execOptions == null ? null : execOptions.getPasswd(), linkedHashMap == null ? null : linkedHashMap.keySet().toArray(new String[0]), linkedHashMap == null ? null : linkedHashMap.values().toArray(new String[0]));
        long l3 = l == 0L ? 0L : System.currentTimeMillis();
        long l4 = l == 0L ? 0L : l3 + l;
        long l5 = 100L;
        do {
            long l6;
            if (l != 0L && (l6 = l4 - l3) < l5) {
                l5 = l6;
            }
            if ((l6 = MvmFactory.nativeGetFactory(l2, l5)) != 0L) {
                this.fFactoryHandle = l6;
                this.fEventMgr = new DefaultEventMgr(new MvmFactoryWrapper(this));
                return;
            }
            if (Thread.interrupted()) {
                this.fFactoryHandle = MvmFactory.nativeCancelFactory(l2);
                if (this.fFactoryHandle == 0L) {
                    throw new InterruptedException();
                }
                this.fEventMgr = new DefaultEventMgr(new MvmFactoryWrapper(this));
                return;
            }
            l3 = System.currentTimeMillis();
        } while (l == 0L || l3 < l4);
        throw new TimeoutException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MvmFactory getLocalFactory() throws IllegalStateException {
        Class<MvmFactory> clazz = MvmFactory.class;
        synchronized (MvmFactory.class) {
            if (sLocalFactory != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return sLocalFactory;
            }
            try {
                sLocalFactory = new MvmFactory(FactoryType.LOCAL, null, null, null, 0L);
            }
            catch (InterruptedException | TimeoutException exception) {
                // empty catch block
            }
            return sLocalFactory;
        }
    }

    public MVM createMVM() throws MvmTerminatedException, IOException {
        return this.createMVM(null);
    }

    public MVM createMVM(@Nullable MvmOptions mvmOptions) throws MvmTerminatedException, IOException {
        if (this.fTerminated.get()) {
            throw new MvmTerminatedException(this.getTerminatedMessage());
        }
        if (this.fType == FactoryType.MATLABMVM) {
            long l = MvmFactory.nativeGetBlessedMVM(this.fFactoryHandle);
            if (l == 0L) {
                throw new MvmTerminatedException("Session or " + this.getTerminatedMessage());
            }
            return MvmFactory.getOrCreateMVM(l);
        }
        Writer writer = null;
        Writer writer2 = null;
        String[] stringArray = null;
        CapabilityList capabilityList = null;
        if (mvmOptions != null) {
            writer = mvmOptions.fOutWriter;
            writer2 = mvmOptions.fErrWriter;
            stringArray = mvmOptions.fPath;
            capabilityList = mvmOptions.fCapabilityList;
        }
        if (null == capabilityList) {
            capabilityList = new CapabilityList(Capability.values());
        }
        ArrayList<Capability> arrayList = Collections.list(capabilityList.elements());
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            nArray[i] = ((Capability)((Object)arrayList.get(i))).getNativeValue();
        }
        long l = MvmFactory.nativeCreateMVM(this.fFactoryHandle, stringArray, writer, writer2, nArray);
        if (l == 0L) {
            throw new MvmTerminatedException("Session or " + this.getTerminatedMessage());
        }
        return MvmFactory.getOrCreateMVM(l);
    }

    public static MVM createLocalMVM(@Nullable MvmOptions mvmOptions) throws IllegalStateException, MvmTerminatedException {
        try {
            return MvmFactory.getLocalFactory().createMVM(mvmOptions);
        }
        catch (IOException iOException) {
            assert (false);
            return null;
        }
    }

    public static MVM getCurrentMVM() throws IllegalStateException {
        long l = MvmFactory.nativeGetCurrentMvmHandle();
        return MvmFactory.getOrCreateMVM(l);
    }

    public int terminate() {
        if (!this.fTerminated.compareAndSet(false, true)) {
            return 0;
        }
        return MvmFactory.nativeTerminateFactory(this.fFactoryHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<MVM> getMVMs() {
        Object object = LOCK;
        synchronized (object) {
            ArrayList<MVM> arrayList = new ArrayList<MVM>(sMvmMap.size());
            for (WeakReference<MVM> weakReference : sMvmMap.values()) {
                MVM mVM = (MVM)weakReference.get();
                if (mVM == null || mVM.isTerminated()) continue;
                arrayList.add(mVM);
            }
            return arrayList;
        }
    }

    private String getTerminatedMessage() {
        return "Factory " + this.getName() + " was terminated.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MVM getOrCreateMVM(long l) {
        Object object = LOCK;
        synchronized (object) {
            MVM mVM = MvmFactory.getMVM(l);
            if (mVM == null) {
                mVM = new MvmImpl(l);
                MvmFactory.addToMap(l, mVM);
            }
            return mVM;
        }
    }

    public static MVM getMvmForHandle(long l) {
        return MvmFactory.getOrCreateMVM(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MVM getMVM(long l) {
        Object object = LOCK;
        synchronized (object) {
            if (sMvmMap == null) {
                return null;
            }
            WeakReference<MVM> weakReference = sMvmMap.get(l);
            if (weakReference == null) {
                return null;
            }
            return (MVM)weakReference.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToMap(long l, MVM mVM) {
        Object object = LOCK;
        synchronized (object) {
            if (sMvmMap == null) {
                sMvmMap = new HashMap(5);
            }
            WeakReference<MVM> weakReference = sMvmMap.put(l, new WeakReference<MVM>(mVM));
            assert (weakReference == null || weakReference.get() == null);
        }
    }

    long getHandle() {
        return this.fFactoryHandle;
    }

    private static native long nativeCreateFactory(int var0, int var1, boolean var2, @Nullable String[] var3, @Nullable String var4, @Nullable String var5, @Nullable String var6, @Nullable String[] var7, @Nullable String[] var8) throws IllegalArgumentException, IllegalStateException, SecurityException, RuntimeException;

    private static native long nativeGetFactory(long var0, long var2) throws IllegalArgumentException, IllegalStateException, SecurityException, RuntimeException;

    private static native long nativeGetLocalFactory() throws IllegalStateException;

    private static native long nativeCancelFactory(long var0);

    private static native long nativeCreateMVM(long var0, @Nullable String[] var2, @Nullable Writer var3, @Nullable Writer var4, @Nullable int[] var5);

    private static native long nativeGetBlessedMVM(long var0);

    private static native long nativeGetCurrentMvmHandle() throws IllegalStateException;

    private static native long nativeGetMvmHandleFromMvmID(long var0);

    private static native int nativeTerminateFactory(long var0);

    static native boolean nativeTerminateMVM(long var0);

    static native boolean nativeIsMvmTerminated(long var0);

    static native boolean nativeBreakInDebugger(long var0);

    static native boolean nativeTerminateSession() throws MvmTerminatedException;

    static native boolean nativeStartSession(int var0, int var1, int var2, boolean var3, @Nullable String[] var4, int var5, int var6) throws MvmTerminatedException, IllegalStateException, IllegalArgumentException;

    static native boolean nativeSessionExists() throws MvmTerminatedException;

    public static native void nativeSetJavaEngine(boolean var0);

    private static native long nativeStartMatlabForEngine(String[] var0) throws IllegalStateException;

    private static native long nativeConnectMatlabForEngine(String var0) throws IllegalStateException;

    private static native String[] nativeFindMatlabForEngine() throws IllegalStateException;

    public static native void nativeReleaseHandleObject(long var0);

    public static native boolean nativeVerifyIdentity(String var0);

    static {
        MvmImpl.loadLibrary();
    }

    public static enum FactoryType {
        LOCAL(1),
        CHILD(2),
        NETWORK(3),
        MATLABMVM(4);

        private final int fValue;

        private FactoryType(int n2) {
            this.fValue = n2;
        }

        int getValue() {
            return this.fValue;
        }
    }

    public static class MvmOptions {
        private final Writer fOutWriter;
        private final Writer fErrWriter;
        private final String[] fPath;
        private final CapabilityList fCapabilityList;

        public MvmOptions() {
            this(null, null, null, null);
        }

        public MvmOptions(@Nullable String[] stringArray, @Nullable Writer writer, @Nullable Writer writer2) {
            this(stringArray, writer, writer2, null);
        }

        public MvmOptions(@Nullable String[] stringArray, @Nullable Writer writer, @Nullable Writer writer2, @Nullable CapabilityList capabilityList) {
            this.fPath = stringArray == null ? null : (String[])stringArray.clone();
            this.fOutWriter = writer;
            this.fErrWriter = writer2;
            this.fCapabilityList = null != capabilityList ? capabilityList : new CapabilityList(Capability.values());
        }

        public MvmOptions(@Nullable Writer writer, @Nullable Writer writer2) {
            this(null, writer, writer2, null);
        }
    }

    public static class ExecOptions {
        private final String fInstallDir;
        private final String fUser;
        private final String fPasswd;
        private final HashMap<String, String> fEnvironment;

        public ExecOptions(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable HashMap<String, String> hashMap) {
            this.fInstallDir = string;
            this.fUser = string2;
            this.fPasswd = string3;
            this.fEnvironment = hashMap;
        }

        public ExecOptions(@Nullable String string, @Nullable String string2, @Nullable HashMap<String, String> hashMap) {
            this(null, string, string2, hashMap);
        }

        public ExecOptions(@Nullable String string, @Nullable String string2) {
            this(null, string, string2, null);
        }

        public ExecOptions(@Nullable HashMap<String, String> hashMap) {
            this(null, null, null, hashMap);
        }

        public String getInstallDir() {
            return this.fInstallDir;
        }

        public String getUser() {
            return this.fUser;
        }

        public String getPasswd() {
            return this.fPasswd;
        }

        public HashMap<String, String> getEnvironment() {
            return this.fEnvironment;
        }
    }

    public static class FactoryOptions
    implements Cloneable {
        private final List<String> fArgs;
        private final JavaLevel fJavaLevel;
        private final boolean fEnableLayeredNetworkStack;
        private static final String[] EMPTY = new String[0];

        public FactoryOptions(String ... stringArray) {
            this((JavaLevel)null, stringArray);
        }

        public FactoryOptions(@Nullable JavaLevel javaLevel, String ... stringArray) {
            this(javaLevel, false, stringArray);
        }

        public FactoryOptions(@Nullable JavaLevel javaLevel, boolean bl, String ... stringArray) {
            this.fJavaLevel = javaLevel == null ? JavaLevel.Undefined : javaLevel;
            this.fArgs = stringArray == null ? null : new ArrayList<String>(Arrays.asList(stringArray));
            this.fEnableLayeredNetworkStack = bl;
        }

        public String[] toArray() {
            return this.fArgs == null ? EMPTY : this.fArgs.toArray(new String[this.fArgs.size()]);
        }

        public JavaLevel getJavaLevel() {
            return this.fJavaLevel;
        }

        public boolean isLayeredNetworkStackEnabled() {
            return this.fEnableLayeredNetworkStack;
        }

        public boolean equals(Object object) {
            if (!(object instanceof FactoryOptions)) {
                return false;
            }
            FactoryOptions factoryOptions = (FactoryOptions)object;
            return factoryOptions.fJavaLevel.equals((Object)this.fJavaLevel) && this.fArgs.size() == factoryOptions.fArgs.size() && this.fArgs.containsAll(factoryOptions.fArgs);
        }

        public int hashCode() {
            return this.fArgs.hashCode() + this.fJavaLevel.hashCode();
        }

        public FactoryOptions clone() {
            try {
                return (FactoryOptions)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }

    public static enum JavaLevel {
        Undefined(0),
        NoJava(1),
        SimpleJVM(2),
        JavaUI(3),
        JavaDesktop(4);

        private final int fValue;

        private JavaLevel(int n2) {
            this.fValue = n2;
        }

        int getValue() {
            return this.fValue;
        }
    }
}

