/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.engine;

import com.mathworks.engine.EngineException;
import com.mathworks.engine.EngineFuture;
import com.mathworks.engine.FutureMatlab;
import com.mathworks.engine.MatlabExecutionException;
import com.mathworks.engine.MatlabSyntaxException;
import com.mathworks.engine.NativeFutureResult;
import com.mathworks.engine.UnsupportedTypeException;
import com.mathworks.javaenginecore.JavaEngineFeval;
import com.mathworks.javaenginecore.MatlabConversionError;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;

public class MatlabEngine {
    public static final Writer NULL_WRITER = new Writer(){

        @Override
        public void write(char[] cArray, int n, int n2) {
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    };
    private String[] eOptions;
    private long mvmID;
    private AtomicBoolean fDisconnected = new AtomicBoolean();
    private final Object diconnectLock = new Object();
    private static final Object connectLock = new Object();
    private static final String sEngineNotSupportedInMatlab = "Initializing MATLAB Engine API from MATLAB is not supported.";
    private static final String sDisconnectedErrorMessage = "MATLAB session is already disconnected.";
    private static final String sNlhsLessThanZero = "Number of output must be greater then or equal to 0.";
    private static final String sMatlabCommandNotEmpty = "MATLAB command must be a non-empty String.";
    private static final String sMatlabNameNotValid = "Name of the shared MATLAB session must be a valid MATLAB variable name.";
    private static final String sMatlabVarNameNotValid = "Invalid MATLAB variable name.";
    private static final String sMatlabNotStarted = "Unable to launch MATLAB.";
    private static final String sMatlabNotAvailable = "MATLAB session is not available.";
    private static final String sFindSharedMatlabError = "Unable to find shared MATLAB sessions.";
    private static final String sMatlabTerminateError = "Unable to terminate MATLAB session.";
    private static DaemonThreadFactory dtFactory;

    private static void verifyNlhs(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(sNlhsLessThanZero);
        }
    }

    private static void verifyMatlabFunc(String string) {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException(sMatlabCommandNotEmpty);
        }
    }

    private static void verifyMatlabSessionName(String string) {
        if (string == null || string.equals("") || !JavaEngineFeval.nativeVerifyIdentity(string)) {
            throw new IllegalArgumentException(sMatlabNameNotValid);
        }
    }

    private static void verifyMatlabVar(String string) {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException(sMatlabVarNameNotValid);
        }
    }

    private MatlabEngine() {
    }

    private MatlabEngine(String[] stringArray) {
        this.eOptions = stringArray;
    }

    public static MatlabEngine startMatlab() throws EngineException, InterruptedException, IllegalArgumentException, IllegalStateException {
        MatlabEngine matlabEngine = new MatlabEngine();
        matlabEngine.open();
        return matlabEngine;
    }

    public static MatlabEngine startMatlab(String[] stringArray) throws EngineException, InterruptedException, IllegalArgumentException, IllegalStateException {
        MatlabEngine matlabEngine = new MatlabEngine(stringArray);
        matlabEngine.open();
        return matlabEngine;
    }

    private static synchronized DaemonThreadFactory getDaemonThreadFactory() {
        if (dtFactory == null) {
            dtFactory = new DaemonThreadFactory();
        }
        return dtFactory;
    }

    public static Future<MatlabEngine> startMatlabAsync() {
        ExecutorService executorService = Executors.newSingleThreadExecutor(MatlabEngine.getDaemonThreadFactory());
        Future<MatlabEngine> future = executorService.submit(new StartMatlabCallable());
        return new FutureMatlab(future);
    }

    public static Future<MatlabEngine> startMatlabAsync(String[] stringArray) {
        ExecutorService executorService = Executors.newSingleThreadExecutor(MatlabEngine.getDaemonThreadFactory());
        Future<MatlabEngine> future = executorService.submit(new StartMatlabCallable(stringArray));
        return new FutureMatlab(future);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MatlabEngine connectMatlab() throws EngineException, InterruptedException {
        MatlabEngine matlabEngine = null;
        Object object = connectLock;
        synchronized (object) {
            String[] stringArray = MatlabEngine.findMatlab();
            matlabEngine = stringArray.length > 0 ? MatlabEngine.connectMatlab(stringArray[0]) : MatlabEngine.startMatlab(new String[]{"-r", "matlab.engine.shareEngine"});
        }
        return matlabEngine;
    }

    public static MatlabEngine connectMatlab(String string) throws EngineException, InterruptedException {
        MatlabEngine.verifyMatlabSessionName(string);
        MatlabEngine matlabEngine = new MatlabEngine();
        try {
            matlabEngine.mvmID = JavaEngineFeval.nativeConnectMATLAB(string);
        }
        catch (IllegalStateException illegalStateException) {
            throw new EngineException("Unable to connect to MATLAB session \"" + string + "\".");
        }
        return matlabEngine;
    }

    public static Future<MatlabEngine> connectMatlabAsync() {
        ExecutorService executorService = Executors.newSingleThreadExecutor(MatlabEngine.getDaemonThreadFactory());
        Future<MatlabEngine> future = executorService.submit(new ConnectMatlabCallable(null));
        return new FutureMatlab(future);
    }

    public static Future<MatlabEngine> connectMatlabAsync(String string) {
        ExecutorService executorService = Executors.newSingleThreadExecutor(MatlabEngine.getDaemonThreadFactory());
        Future<MatlabEngine> future = executorService.submit(new ConnectMatlabCallable(string));
        return new FutureMatlab(future);
    }

    public static String[] findMatlab() throws EngineException {
        String[] stringArray;
        try {
            stringArray = (String[])JavaEngineFeval.nativeFindMatlab();
        }
        catch (IllegalStateException illegalStateException) {
            throw new EngineException(sFindSharedMatlabError);
        }
        return stringArray;
    }

    public static Future<String[]> findMatlabAsync() {
        ExecutorService executorService = Executors.newSingleThreadExecutor(MatlabEngine.getDaemonThreadFactory());
        Future<String[]> future = executorService.submit(new FindMatlabCallable());
        return future;
    }

    private void open() throws EngineException, InterruptedException, IllegalArgumentException {
        try {
            this.mvmID = JavaEngineFeval.nativeOpen(this.eOptions);
        }
        catch (IllegalStateException illegalStateException) {
            throw new EngineException(illegalStateException.getMessage());
        }
    }

    public void eval(String string) throws InterruptedException, MatlabExecutionException, MatlabSyntaxException, CancellationException, EngineException, ExecutionException {
        MatlabEngine.verifyMatlabFunc(string);
        this.feval(0, "eval", string);
    }

    public Future<Void> evalAsync(String string) {
        return this.evalAsync(string, new PrintWriter(System.out), new PrintWriter(System.err));
    }

    public void eval(String string, Writer writer, Writer writer2) throws MatlabExecutionException, MatlabSyntaxException, EngineException, InterruptedException, ExecutionException {
        MatlabEngine.verifyMatlabFunc(string);
        this.feval(0, "eval", writer, writer2, string);
    }

    public Future<Void> evalAsync(String string, Writer writer, Writer writer2) {
        MatlabEngine.verifyMatlabFunc(string);
        Future<Void> future = null;
        try {
            future = this.fevalAsync(0, "eval", writer, writer2, string);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            throw new IllegalStateException(sMatlabNotAvailable);
        }
        return future;
    }

    public <T> T feval(String string, Object ... objectArray) throws RejectedExecutionException, EngineException, InterruptedException, ExecutionException {
        T t = this.feval(1, string, (Writer)new PrintWriter(System.out), new PrintWriter(System.err), objectArray);
        return t;
    }

    public <T> Future<T> fevalAsync(String string, Object ... objectArray) {
        Future<T> future = this.fevalAsync(1, string, (Writer)new PrintWriter(System.out), new PrintWriter(System.err), objectArray);
        return future;
    }

    public <T> T feval(String string, Writer writer, Writer writer2, Object ... objectArray) throws RejectedExecutionException, EngineException, InterruptedException, ExecutionException {
        T t = this.feval(1, string, writer, writer2, objectArray);
        return t;
    }

    public <T> Future<T> fevalAsync(String string, Writer writer, Writer writer2, Object ... objectArray) throws RejectedExecutionException {
        Future<T> future = this.fevalAsync(1, string, writer, writer2, objectArray);
        return future;
    }

    public <T> T feval(int n, String string, Object ... objectArray) throws MatlabExecutionException, MatlabSyntaxException, EngineException, InterruptedException, ExecutionException {
        T t = this.feval(n, string, (Writer)new PrintWriter(System.out), new PrintWriter(System.err), objectArray);
        return t;
    }

    public <T> Future<T> fevalAsync(int n, String string, Object ... objectArray) throws RejectedExecutionException {
        Future<T> future = this.fevalAsync(n, string, (Writer)new PrintWriter(System.out), new PrintWriter(System.err), objectArray);
        return future;
    }

    public <T> T feval(int n, String string, Writer writer, Writer writer2, Object ... objectArray) throws RejectedExecutionException, EngineException, InterruptedException, ExecutionException {
        MatlabEngine.verifyNlhs(n);
        MatlabEngine.verifyMatlabFunc(string);
        try {
            Object t = JavaEngineFeval.feval(n, this.mvmID, string, writer, writer2, objectArray);
            return t;
        }
        catch (MatlabConversionError matlabConversionError) {
            throw new UnsupportedTypeException(matlabConversionError.getLocalizedMessage());
        }
    }

    public <T> Future<T> fevalAsync(int n, String string, Writer writer, Writer writer2, Object ... objectArray) throws RejectedExecutionException {
        MatlabEngine.verifyNlhs(n);
        MatlabEngine.verifyMatlabFunc(string);
        long l = 0L;
        try {
            l = JavaEngineFeval.fevalAsync(n, this.mvmID, string, writer, writer2, objectArray);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            throw new IllegalStateException(sMatlabNotAvailable);
        }
        NativeFutureResult nativeFutureResult = new NativeFutureResult(l, writer, writer2);
        EngineFuture engineFuture = new EngineFuture(nativeFutureResult);
        return engineFuture;
    }

    public <T> void putVariable(String string, T t) throws InterruptedException, EngineException, CancellationException, IllegalStateException, ExecutionException {
        MatlabEngine.verifyMatlabVar(string);
        this.feval(0, "assignin", (Writer)null, null, "base".toCharArray(), string.toCharArray(), t);
    }

    public <T> Future<Void> putVariableAsync(String string, T t) throws InterruptedException, EngineException, IllegalStateException {
        MatlabEngine.verifyMatlabVar(string);
        Future<Void> future = null;
        future = this.fevalAsync(0, "assignin", (Writer)null, null, "base".toCharArray(), string.toCharArray(), t);
        return future;
    }

    public <T> T getVariable(String string) throws InterruptedException, CancellationException, IllegalStateException, EngineException, ExecutionException {
        MatlabEngine.verifyMatlabVar(string);
        T t = this.feval("matlab.internal.engine.getVariable", new Object[]{string.toCharArray()});
        return t;
    }

    public <T> Future<T> getVariableAsync(String string) throws InterruptedException, CancellationException, IllegalStateException, EngineException, ExecutionException {
        MatlabEngine.verifyMatlabVar(string);
        Future<T> future = null;
        try {
            future = this.fevalAsync("matlab.internal.engine.getVariable", new Object[]{string.toCharArray()});
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            throw new IllegalStateException(sMatlabNotAvailable);
        }
        return future;
    }

    public void disconnect() throws EngineException {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> disconnectAsync() {
        Object object = this.diconnectLock;
        synchronized (object) {
            if (this.fDisconnected.get()) {
                throw new IllegalStateException(sDisconnectedErrorMessage);
            }
            ExecutorService executorService = Executors.newSingleThreadExecutor(MatlabEngine.getDaemonThreadFactory());
            Future<Void> future = executorService.submit(new DisconnectMatlabCallable(this));
            return future;
        }
    }

    public void quit() throws InterruptedException, EngineException {
        Future<Void> future = this.quitAsync();
        try {
            future.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            JavaEngineFeval.nativeClose(this.mvmID);
        }
        catch (IllegalStateException illegalStateException) {
            throw new EngineException(sMatlabTerminateError);
        }
    }

    public Future<Void> quitAsync() throws InterruptedException {
        Future<Void> future = this.evalAsync("exit");
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws EngineException {
        Object object = this.diconnectLock;
        synchronized (object) {
            if (this.fDisconnected.get()) {
                throw new IllegalStateException(sDisconnectedErrorMessage);
            }
            try {
                JavaEngineFeval.nativeClose(this.mvmID);
                this.fDisconnected.set(true);
            }
            catch (IllegalStateException illegalStateException) {
                throw new EngineException(sMatlabTerminateError);
            }
        }
    }

    public static void terminateEngineClient() throws EngineException {
        try {
            JavaEngineFeval.nativeCloseSession();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class DisconnectMatlabCallable
    implements Callable {
        private MatlabEngine engine;

        public DisconnectMatlabCallable(MatlabEngine matlabEngine) {
            this.engine = matlabEngine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void call() throws Exception {
            Object object = this.engine.diconnectLock;
            synchronized (object) {
                if (!this.engine.fDisconnected.get()) {
                    this.engine.close();
                }
                return null;
            }
        }
    }

    private static class FindMatlabCallable
    implements Callable<String[]> {
        private FindMatlabCallable() {
        }

        @Override
        public String[] call() throws Exception {
            return MatlabEngine.findMatlab();
        }
    }

    private static class ConnectMatlabCallable
    implements Callable<MatlabEngine> {
        private String name;

        public ConnectMatlabCallable(String string) {
            this.name = string;
        }

        @Override
        public MatlabEngine call() throws Exception {
            if (this.name == null) {
                return MatlabEngine.connectMatlab();
            }
            return MatlabEngine.connectMatlab(this.name);
        }
    }

    private static class StartMatlabCallable
    implements Callable<MatlabEngine> {
        private String[] eOptions;

        public StartMatlabCallable() {
        }

        public StartMatlabCallable(String[] stringArray) {
            this.eOptions = stringArray;
        }

        @Override
        public MatlabEngine call() throws Exception {
            return MatlabEngine.startMatlab(this.eOptions);
        }
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    }
}

