/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.engine;

import com.mathworks.engine.EngineException;
import com.mathworks.engine.MatlabEngine;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FutureMatlab
implements Future {
    private Future<MatlabEngine> fResult;
    private static final String sMatlabNotStarted = "Unable to launch MATLAB or connect a shared MATLAB session.";

    public FutureMatlab(Future future) {
        this.fResult = future;
    }

    @Override
    public boolean isDone() {
        return this.fResult.isDone();
    }

    @Override
    public boolean isCancelled() {
        return this.fResult.isCancelled();
    }

    @Override
    public boolean cancel(boolean bl) {
        if (this.isDone() || this.isCancelled()) {
            return false;
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ((MatlabEngine)FutureMatlab.this.fResult.get()).close();
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
            }
        }, "closeMatlabRunnableThread");
        thread.setDaemon(true);
        thread.start();
        return true;
    }

    public MatlabEngine get() throws EngineException, InterruptedException {
        try {
            return this.fResult.get();
        }
        catch (IllegalStateException | ExecutionException exception) {
            throw new EngineException(sMatlabNotStarted);
        }
    }

    public MatlabEngine get(long l, TimeUnit timeUnit) throws EngineException, InterruptedException, TimeoutException {
        try {
            return this.fResult.get(l, timeUnit);
        }
        catch (IllegalStateException | ExecutionException exception) {
            throw new EngineException(sMatlabNotStarted);
        }
    }
}

