/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.engine;

import com.mathworks.engine.NativeFutureResult;
import com.mathworks.engine.UnsupportedTypeException;
import com.mathworks.javaenginecore.MatlabConversionError;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EngineFuture<V>
implements Future<V> {
    private static final double DEFAULT_INTERVAL_SECS = 1.0;
    V fResult;
    boolean fGetCalled;
    private final NativeFutureResult<V> fNativeFutureResult;
    private volatile CancelState fCancelState = CancelState.NONE;

    EngineFuture(NativeFutureResult<V> nativeFutureResult) {
        this.fNativeFutureResult = nativeFutureResult;
    }

    @Override
    public boolean cancel(boolean bl) {
        if (this.fCancelState != CancelState.NONE) {
            return false;
        }
        boolean bl2 = this.fNativeFutureResult.cancel(bl);
        this.fCancelState = bl2 ? CancelState.SUBMITTED : CancelState.FAILED;
        return bl2;
    }

    @Override
    public boolean isCancelled() {
        if (this.fCancelState == CancelState.NONE && this.fNativeFutureResult.isCancelled()) {
            this.fCancelState = CancelState.SUBMITTED;
        }
        return this.fCancelState == CancelState.SUBMITTED;
    }

    @Override
    public boolean isDone() {
        return this.fCancelState != CancelState.NONE || this.fNativeFutureResult.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        this.waitInternal(0L, null, true);
        try {
            return this.getInternal();
        }
        catch (MatlabConversionError matlabConversionError) {
            throw new UnsupportedTypeException(matlabConversionError.getLocalizedMessage());
        }
    }

    @Override
    public V get(long l, @NotNull TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        boolean bl = this.waitInternal(l, timeUnit, true);
        if (!bl) {
            throw new TimeoutException();
        }
        try {
            return this.getInternal();
        }
        catch (MatlabConversionError matlabConversionError) {
            throw new UnsupportedTypeException(matlabConversionError.getLocalizedMessage());
        }
    }

    private static boolean isEventDispatchThread() {
        try {
            return SwingUtilities.isEventDispatchThread();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private boolean waitInternal(long l, @Nullable TimeUnit timeUnit, boolean bl) throws IllegalStateException, InterruptedException, CancellationException {
        if (l < 0L) {
            throw new IllegalArgumentException("Timeout cannot be negative");
        }
        if (!this.isDone() && EngineFuture.isEventDispatchThread()) {
            throw new IllegalStateException("Blocking in Event Dispatch Thread not allowed");
        }
        long l2 = timeUnit == null ? 0L : System.currentTimeMillis();
        long l3 = timeUnit == null ? 0L : l2 + TimeUnit.MILLISECONDS.convert(l, timeUnit);
        double d = 1.0;
        boolean bl2 = false;
        do {
            boolean bl3 = this.isCancelled();
            if (timeUnit != null) {
                long l4 = l3 - l2;
                double d2 = (double)l4 / 1000.0;
                if (d2 < d) {
                    d = d2;
                }
                if (bl2) {
                    Thread.sleep((long)d);
                }
            }
            if (!bl2) {
                try {
                    boolean bl4 = this.fNativeFutureResult.waitForCompletion(d);
                    if (bl4) {
                        return true;
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    if (timeUnit == null) {
                        throw new IllegalStateException("Call to get() or waitForCompletion() in MATLAB thread would block forever");
                    }
                    bl2 = true;
                    continue;
                }
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
            }
            if (bl && bl3) {
                throw new CancellationException();
            }
            if (timeUnit == null) continue;
            l2 = System.currentTimeMillis();
        } while (timeUnit == null || l2 < l3);
        return false;
    }

    protected V getInternal() throws InterruptedException, CancellationException, MatlabConversionError {
        if (this.fGetCalled) {
            return this.fResult;
        }
        V v = this.fNativeFutureResult.get();
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        this.fResult = v;
        this.fGetCalled = true;
        return this.fResult;
    }

    private static enum CancelState {
        NONE,
        SUBMITTED,
        FAILED;

    }
}

