/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.capabilities;

import com.mathworks.capabilities.Capability;
import com.mathworks.capabilities.CapabilityList;
import java.util.Enumeration;

public class UnsatisfiedCapabilityException
extends Exception {
    private final CapabilityList available;
    private final CapabilityList required;
    private final CapabilityList unsatisfied;

    public UnsatisfiedCapabilityException(CapabilityList capabilityList, CapabilityList capabilityList2, CapabilityList capabilityList3) {
        super(UnsatisfiedCapabilityException.getMessage(capabilityList3));
        this.available = capabilityList;
        this.required = capabilityList2;
        this.unsatisfied = capabilityList3;
    }

    public CapabilityList getAvailableCapabilities() {
        return this.available;
    }

    public CapabilityList getRequiredCapabilities() {
        return this.required;
    }

    public CapabilityList getUnsatisfiedCapabilities() {
        return this.unsatisfied;
    }

    private static String getMessage(CapabilityList capabilityList) {
        StringBuilder stringBuilder = new StringBuilder("Required capabilities are currently unsupported:");
        Enumeration<Capability> enumeration = capabilityList.elements();
        while (enumeration.hasMoreElements()) {
            stringBuilder.append(" ");
            stringBuilder.append((Object)enumeration.nextElement());
        }
        return stringBuilder.toString();
    }
}

