/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.capabilities;

import com.mathworks.capabilities.Capability;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;

public class CapabilityList
implements Cloneable {
    private static final AtomicInteger BITSET_SIZE = new AtomicInteger(-1);
    private final BitSet fBitSet;

    public CapabilityList() {
        int n = BITSET_SIZE.get();
        if (n < 0) {
            for (Capability capability : Capability.values()) {
                n = Math.max(n, capability.getNativeValue());
            }
            BITSET_SIZE.set(n);
        }
        this.fBitSet = new BitSet(n + 1);
    }

    public CapabilityList(Capability ... capabilityArray) {
        this(Arrays.asList(capabilityArray));
    }

    public CapabilityList(Iterable<Capability> iterable) {
        this(iterable.iterator());
    }

    public CapabilityList(Iterator<Capability> iterator) {
        this();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    public CapabilityList(Enumeration<Capability> enumeration) {
        this();
        while (enumeration.hasMoreElements()) {
            this.add(enumeration.nextElement());
        }
    }

    public boolean isEmpty() {
        return this.fBitSet.isEmpty();
    }

    private CapabilityList(BitSet bitSet) {
        this.fBitSet = bitSet;
    }

    public CapabilityList add(Capability capability) {
        this.fBitSet.set(capability.getNativeValue());
        return this;
    }

    public CapabilityList add(CapabilityList capabilityList) {
        this.fBitSet.or(capabilityList.fBitSet);
        return this;
    }

    public CapabilityList remove(Capability capability) {
        this.fBitSet.clear(capability.getNativeValue());
        return this;
    }

    public CapabilityList remove(CapabilityList capabilityList) {
        this.fBitSet.andNot(capabilityList.fBitSet);
        return this;
    }

    public CapabilityList intersect(CapabilityList capabilityList) {
        this.fBitSet.and(capabilityList.fBitSet);
        return this;
    }

    public int size() {
        return this.fBitSet.cardinality();
    }

    public Enumeration<Capability> elements() {
        final BitSet bitSet = this.fBitSet;
        return new Enumeration<Capability>(){
            private int index;
            {
                this.index = bitSet.nextSetBit(0);
            }

            @Override
            public boolean hasMoreElements() {
                return -1 != this.index;
            }

            @Override
            public Capability nextElement() throws NoSuchElementException {
                if (-1 == this.index) {
                    throw new NoSuchElementException();
                }
                Capability capability = Capability.fromNative(this.index);
                this.index = bitSet.nextSetBit(this.index + 1);
                return capability;
            }
        };
    }

    public Object clone() throws CloneNotSupportedException {
        return new CapabilityList((BitSet)this.fBitSet.clone());
    }
}

