/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.capabilities;

import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public enum Capability {
    InteractiveCommandLine("InteractiveCommandLine"),
    Swing("Swing"),
    ComplexSwing("ComplexSwing"),
    LocalClient("LocalClient"),
    WebWindow("WebWindow"),
    ModalDialogs("ModalDialogs"),
    Debugging("Debugging");

    private final int fNativeValue;
    private static final ConcurrentMap<Integer, Capability> NATIVE2ENUMMAP;

    private Capability(String string2) {
        System.loadLibrary("nativecapabilities");
        this.fNativeValue = Capability.getValueByName(string2);
    }

    public int getNativeValue() {
        return this.fNativeValue;
    }

    public static Capability fromNative(int n) {
        Capability capability = (Capability)((Object)NATIVE2ENUMMAP.get(n));
        if (capability == null) {
            for (Capability capability2 : Arrays.asList(Capability.values())) {
                int n2 = capability2.getNativeValue();
                NATIVE2ENUMMAP.putIfAbsent(n2, capability2);
                if (n2 != n) continue;
                capability = capability2;
            }
        }
        return capability;
    }

    private static native int getValueByName(String var0);

    static {
        NATIVE2ENUMMAP = new ConcurrentHashMap<Integer, Capability>();
    }
}

