/*
 * Decompiled with CFR 0.152.
 */
package matlabenginetest;

import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import matlabenginetest.MatBuild;
import matlabenginetest.TimerCheck;
import matprodalgorithms.MatMultEJML;
import matprodalgorithms.MatMultMatlabEng;
import matprodalgorithms.MatMultNominal;

public class MatlabEngineTest {
    public static void main(String[] args) {
        double[][] matProdMatlab;
        FileWriter fw = null;
        int matSize = 1000;
        int numPrepRuns = 20;
        int numTestRuns = 20;
        int mXTest = 314;
        int mYTest = 789;
        ArrayList<Object> al = new ArrayList();
        MatBuild mb = new MatBuild(matSize);
        TimerCheck timerMatlabPrep = new TimerCheck("Matlab Warm-up: ");
        TimerCheck timerMatlab = new TimerCheck("Matlab Matrix Multiplication: ");
        MatMultMatlabEng mmm = new MatMultMatlabEng();
        TimerCheck timerNom = new TimerCheck("Conventional Matrix Multiplication: ");
        MatMultNominal mmn = new MatMultNominal(matSize);
        TimerCheck timerEJML = new TimerCheck("EJML Matrix Multiplication: ");
        MatMultEJML ejmlMatrix = new MatMultEJML(matSize);
        String dividerLine = "------------------------------------------------------------\n";
        int ctr = 1;
        String fileMsg = " ";
        try {
            fw = new FileWriter("data.txt");
        }
        catch (IOException e) {
            System.out.println("File IO Error: " + e);
        }
        al = mb.getAandBMatrices();
        double[][] matA = (double[][])al.get(0);
        double[][] matB = (double[][])al.get(1);
        System.out.println("Prepping Matlab Engine ...\n");
        try {
            for (int i = 0; i < numPrepRuns; ++i) {
                al = mb.getAandBMatrices();
                matA = (double[][])al.get(0);
                matB = (double[][])al.get(1);
                mmm.loadMatrices(matA, matB);
                timerMatlabPrep.startTimer();
                matProdMatlab = mmm.getMatLabMatProd();
                timerMatlabPrep.stopTimer();
                fileMsg = String.valueOf(ctr) + ", " + String.valueOf(timerMatlabPrep.getTime()) + ", 0, 0\n";
                fw.write(fileMsg);
                ++ctr;
            }
        }
        catch (IOException e) {
            System.out.println("File-write error: " + e);
        }
        System.out.println("Prepping Complete.\n");
        for (int i = 0; i < numTestRuns; ++i) {
            System.out.println(dividerLine);
            al = mb.getAandBMatrices();
            matA = (double[][])al.get(0);
            matB = (double[][])al.get(1);
            mmn.loadMatrices(matA, matB);
            timerNom.startTimer();
            double[][] matProdNom = mmn.multMatrices();
            timerNom.stopTimer();
            System.out.println(timerNom.retrieveTimerInfo());
            System.out.println("==> Conventional Matrix[" + mXTest + "][" + mYTest + "] = " + matProdNom[mXTest][mYTest]);
            System.out.println("\n");
            ejmlMatrix.loadMatrices(matA, matB);
            timerEJML.startTimer();
            double[][] matProdEJML = ejmlMatrix.multMatrices();
            timerEJML.stopTimer();
            System.out.println(timerEJML.retrieveTimerInfo());
            System.out.println("==> EJML Matrix[" + mXTest + "][" + mYTest + "] = " + matProdEJML[mXTest][mYTest]);
            System.out.println("\n");
            mmm.loadMatrices(matA, matB);
            timerMatlab.startTimer();
            matProdMatlab = mmm.getMatLabMatProd();
            timerMatlab.stopTimer();
            System.out.println(timerMatlab.retrieveTimerInfo());
            System.out.println("==> Matlab Matrix[" + mXTest + "][" + mYTest + "] = " + matProdMatlab[mXTest][mYTest]);
            System.out.println("\n");
            String msg0 = String.valueOf(ctr);
            String msg1 = String.valueOf(timerMatlab.getTime());
            String msg2 = String.valueOf(timerEJML.getTime());
            String msg3 = String.valueOf(timerNom.getTime());
            fileMsg = msg0 + ", " + msg1 + ", " + msg2 + ", " + msg3 + "\n";
            ++ctr;
            try {
                fw.write(fileMsg);
                continue;
            }
            catch (IOException e) {
                System.out.println("IO Error: " + e);
            }
        }
        mmm.stopMatlabEngine();
        try {
            fw.close();
        }
        catch (IOException e) {
            System.out.println("IO Error: " + e);
        }
    }
}

