function[dataNet] = tstnet(iter,dataNet)
% Tests a trained Neural Network.
% tstnet = test a Neural Network
% 
% 

% Flag for displaying plot of final data
testDisp    = dataNet.testDisp;

% For debugging purposes.
testPlots   = 0;

% Load the pertinent parameters from the Neural Network data structure.
% Note that dataNet.net stores multiple Neural Networks if multiple 
% Neural Networks are generated.  During the test phase (this function),
% each Neural Network is pulled from the data structure and tested.

%**************************************************************************
% Matlab LM algorithm (deprecated function "newff")
if dataNet.lmType <= 2
    
    dataNet = testNewffNet(iter,dataNet);
    
%**************************************************************************
% Matlab LM algorithm (latest architecture functions)
elseif dataNet.lmType == 3 
    
    dataNet = testFFNet(iter,dataNet);
    
%**************************************************************************
% Pyrenn LM algorithm
elseif dataNet.lmType == 4
    
    dataNet = testPyrennNet(iter,dataNet);
    
end
%**************************************************************************

err     = dataNet.err(iter);

%--------------------------------------------------------------------------
% For debugging purposes.
if testPlots == 1
	figure(1);
	ninSize = size(ntest_in);
	plot(1:ninSize(2),ntest_in,'b*');
	title('Scaled Test Input Data');
	grid on;

	figure(2);
	noutSize = size(ynet);
	plot(1:ninSize(2),ynet,'b*');
	title('Neural Network Outputs');
	grid on;
end
%--------------------------------------------------------------------------

%--------------------------------------------------------------------------
% If testing the Neural Network with lowest error then % plot the display 
% of data.  This only occurs at the end of function mn when all of the
% Neural Networks have been tested and the one with the lowest error is
% selected for the final plot.

if testDisp == 1

    finalDisplay(iter,dataNet);
    
end

fprintf(1,'=> Error = %6.1f\n',err);

% Load the data structure with the error value.
dataNet.err(iter)		= err;

end

