function[dataNet] = trnet(iter,dataNet)
% Builds and trains a Neural Network - for either the Matlab LM algorithm
% or for the Pyrenn LM algorithm.
% trnet = train Neural Network

lmType = dataNet.lmType;

%**************************************************************************
% Matlab LM algorithm (deprecated function "newff")
if lmType <= 2
    
    net = trainNewffNet(dataNet);

%**************************************************************************
% Matlab LM algorithm (latest architecture functions)
elseif lmType == 3

    net = trainFFNet(dataNet);
    
%**************************************************************************
% Pyrenn LM algorithm
elseif lmType == 4

    net = trainPyrennNet(dataNet);
    
end

% Load the Neural Network object into the data structure.
dataNet.net{iter}	= net;

end


