function [net] = trainPyrennNet(dataNet)

% Retrieve the selected Neural Network architecture number.
anet    = dataNet.anet;
% Training inputs
P       = dataNet.P;
% Training outputs
Y       = dataNet.Y;

% Select the Neural Network architecture.
switch anet
    case 1
        nn = [1 8 8 8 1];																	
    case 2
        nn = [1 8 8 1];																	
    case 3   
        nn = [1 4 4 1];																	
    case 4   
        nn = [1 4 1];																	
    otherwise   
        nn = [1 2 1];																	
end

% Build the Neural Network.
net = CreateNN(nn);     
% Train the Neural Network.
net = train_LM(P,Y,net,dataNet.epoch,dataNet.optErr);

end