function [net] = trainNewffNet(dataNet)

lmType = dataNet.lmType;

% Neural Network input training set.
if lmType == 1
    nnet_in         = dataNet.nnet_in;
elseif lmType == 2
    nnet_in         = dataNet.P;
end

% Neural Network output training set.
if lmType == 1
    nnet_out		= dataNet.nnet_out;
elseif lmType == 2
    nnet_out        = dataNet.Y;
end

% Selected Neural Network architecture number.
anet			= dataNet.anet;

%**********************************************************************
%
%  Train the Neural Network using the 
%  Levenberg-Marquardt optimization algorithm.
%
%**********************************************************************

% This file loads the training sets and starts the training session.

% EXAMPLE
%nnetin = [0.5 0.3 0.5; -0.2 -0.5 -0.1];
%nnetout = [0.2 0.5 0.1 0.2; -0.5 -0.2 -0.3 -0.1];

%P = [0 .1  .2 .3   .4 .5 .6  .7  .8  -.6  -.10];
%T = [0 .1 -.3 .73 -.5 .2 .24 .1 -.2   .3   .4];

%nnet_in = P;
%nnet_out = T;

% Initialize feedforward Neural Network.  
% Use Levenberg-Marquardt optimization
% method for training the Neural Network. 

if lmType == 1
    outActFunc = 'tansig';
elseif lmType == 2
    outActFunc = 'poslin';
end

% Select the Neural Network architecture.
switch anet
   case 1
        net = newff(minmax(nnet_in),[8,8,8,1], ...
                      {'tansig' 'tansig' 'tansig' outActFunc},'trainlm');																	
   case 2
        net = newff(minmax(nnet_in),[8,8,1], ...
                             {'tansig' 'tansig' outActFunc},'trainlm');																	
   case 3   
        net = newff(minmax(nnet_in),[4,4,1], ...
                             {'tansig' 'tansig' outActFunc},'trainlm');																	
   case 4   
        net = newff(minmax(nnet_in),[4,1], ...
                                      {'tansig' outActFunc},'trainlm');																	
    otherwise   
        net = newff(minmax(nnet_in),[2,1], ...
                                      {'tansig' outActFunc},'trainlm');																	
end

% Set up training parameters

% Number of times to display status
net.trainParam.show = 5;
% Max number of optimization (training) iterations
net.trainParam.epochs = dataNet.epoch; 
% Target Mean Squared Error (MSE) 
net.trainParam.goal = dataNet.optErr; % 

% Load the traing input and output test sets.
p = nnet_in;   
t = nnet_out;

% Build the Neural Network object and train the Neural Network.
net = train(net,p,t);

% Close plot.
close all;

end