function [net] = trainFFNet(dataNet)

% Retrieve the selected Neural Network architecture number.
anet    = dataNet.anet;
% Training input set
P       = dataNet.P;
% Training output set
Y       = dataNet.Y;

outputActFunc = dataNet.actFunc;

% Select the Neural Network architecture.
switch anet
    case 1
        net = feedforwardnet([8,8,8], 'trainlm');
        % Configure hidden layers
        for i = 1: 3
            net.layers{i}.transferFcn = 'tansig';
        end
        % Configure output layer
        net.layers{4}.transferFcn = outputActFunc;

    case 2
        net = feedforwardnet([8,8], 'trainlm');
        % Configure hidden layers
        for i = 1: 2
            net.layers{i}.transferFcn = 'tansig';
        end
        % Configure output layer
        net.layers{3}.transferFcn = outputActFunc;

    case 3   
        net = feedforwardnet([4,4], 'trainlm');
        % Configure hidden layers
        for i = 1: 2
            net.layers{i}.transferFcn = 'tansig';
        end
        % Configure output layer
        net.layers{3}.transferFcn = outputActFunc;

    case 4   
        net = feedforwardnet(4, 'trainlm');
        % Configure hidden layers
        for i = 1: 1
            net.layers{i}.transferFcn = 'tansig';
        end
        % Configure output layer
        net.layers{2}.transferFcn = outputActFunc;

    otherwise
        net = feedforwardnet(2, 'trainlm');
        % Configure hidden layers
        for i = 1: 1
            net.layers{i}.transferFcn = 'tansig';
        end
        % Configure output layer
        net.layers{2}.transferFcn = outputActFunc;
end
    
% Set the maximum number of epochs to train
net.trainParam.epochs = dataNet.epoch;

% Set the maximum validation failures
net.trainParam.max_fail	= 6;	

% Set the minimum performance gradient
net.trainParam.min_grad = dataNet.optErr;

% Generate command-line output
net.trainParam.showCommandLine = false;	

% Show training GUI
net.trainParam.showWindow =	true;	

% Set the maximum time to train in seconds
net.trainParam.time = inf;

% Train the Neural Network.
net = train(net,P,Y);

end