function [dataNet] = testNewffNet(iter,dataNet)

% Retrieve the Neural Network object.
net     = dataNet.net{iter};
% Retrieve the Neural Network type.
lmType  = dataNet.lmType;
   
% Use the scaled input and output data values.
if lmType == 1
    
    ntest_in    = dataNet.ntest_in;
    ntest_out   = dataNet.ntest_out;
    Ptest       = dataNet.Ptest;
    
    m_out       = dataNet.m_out;
    b_out       = dataNet.b_out;
    
% Use the unscaled (raw) input and output data values.    
elseif lmType == 2
    
    Ptest	= dataNet.Ptest;
    Ytest	= dataNet.Ytest;

end

%----------------------------------------------------------------------
% Build reference curve.

% Compute minimum value for plot.
xmin = min(Ptest);
% Compute maximum value for plot.
xmax = max(Ptest);
% Generate array of x values for reference curve.
xref = xmin : 0.5 : xmax;
dataNet.xref = xref;
% Compute the size of the array.
xSize = size(xref);
% Generate array of y values for reference curve.
for i = 1: xSize(2)
   yref(i) = xref(i) * xref(i);
end
dataNet.yref = yref;

%----------------------------------------------------------------------
% Active Neural Network using the test inputs.
if lmType == 1
    yout = net(ntest_in);
elseif lmType == 2
    yout = net(Ptest);
end
% Save the output.
dataNet.yout = yout;

%----------------------------------------------------------------------
% Compute accumulative error.  This is defined as:
% Sum of ( Neural Network outputs - test outputs ) 
ySize = size(yout);
err = 0.0;
for i = 1: ySize(2)
    
   if lmType == 1
       youtP = (yout(i) - b_out) / m_out;
       netOutP = (ntest_out(i) - b_out) / m_out;
       
       err = err + abs( ( youtP - netOutP ) );
   elseif lmType == 2
       err = err + abs( ( yout(i) - Ytest(i) ) );
   end
   
end

% Load the data structure with the error value.
dataNet.err(iter)		= err;

end