function [dataNet] = testFFNet(iter,dataNet)

% Retrieve the Neural Network object.
net     = dataNet.net{iter};

% Array of test input values
Ptest   = dataNet.Ptest;
% Arra of test output values
Ytest   = dataNet.Ytest;

%----------------------------------------------------------------------
% Build reference curve.

% Compute minimum value for plot.
xmin    = min(Ptest);
% Compute maximum value for plot.
xmax    = max(Ptest);
% Generate array of x values for reference curve.
xref    = xmin : 0.5 : xmax;
dataNet.xref = xref;
% Compute the size of the array.
xSize   = size(xref);
% Generate array of y values for reference curve.
for i = 1: xSize(2)
   yref(i) = xref(i) * xref(i);
end
dataNet.yref = yref;

%----------------------------------------------------------------------
% Active Neural Network using the test inputs.

yout = net(Ptest);
dataNet.yout = yout;
%----------------------------------------------------------------------
% Scale the Neural Network outputs to be compared 
% against the reference curve.

% Compute accumulative error.  This is defined as:
% Sum of ( Neural Network outputs - test outputs ) 
ySize = size(yout);
err = 0.0;
for i = 1: ySize(2)
   err = err + abs( ( yout(i) - Ytest(i) ) );
end

dataNet.err(iter) = err;

end