function finalDisplay(iter,dataNet)

testDataSize    = dataNet.testDataSize;
setYPlotLimits  = dataNet.setYPlotLimits; 
if setYPlotLimits == true
    yPlotLimits = dataNet.yPlotLimits;
end;

if dataNet.lmType < 4
    figure(3);
else
    figure(4);
end


if dataNet.lmType > 1
    plot(dataNet.xref,dataNet.yref,'k',dataNet.P,dataNet.Y,'b*', ...
        dataNet.Ptest,dataNet.Ytest,'ro',dataNet.Ptest,dataNet.yout,'r*');

     if setYPlotLimits == true
         xPlotLimits = [dataNet.Ptest(1) dataNet.Ptest(end)];
         axis([xPlotLimits yPlotLimits]);
     end

else
    yout = dataNet.yout;
    yout = (yout - dataNet.b_out) / dataNet.m_out;
    
    plot(dataNet.xref,dataNet.yref,'k',dataNet.x,dataNet.y,'b*', ...
                dataNet.xt,dataNet.yt,'ro',dataNet.xt,yout,'r*');

     if setYPlotLimits == true
         xPlotLimits = [dataNet.xt(1) dataNet.xt(end)];
         axis([xPlotLimits yPlotLimits]);
     end

end

grid on;
xlabel('X');
ylabel('Y');
legend('Reference Curve','Training Data','Test Data', ...
                                            'Neural Network Output');

err     = dataNet.err(iter);
fprintf(1,'Final Error = %6.1f\n',err);
dispErr = sprintf('%0.1f', err);
textStr = strcat('Final Error =  ',dispErr);

if testDataSize == 1
    text(-10,270,textStr);
elseif testDataSize == 2
    text(-10,400,textStr);
elseif testDataSize == 3
    text(-30,2250,textStr);
else
    text(-60,7500,textStr);
end

dispTime = sprintf('%0.1f',dataNet.total_time);
textStr = strcat('Total Training Time =  ',dispTime,'  seconds');

if testDataSize == 1
    text(-10,240,textStr);
elseif testDataSize == 2
    text(-10,350,textStr);
elseif testDataSize == 3
    text(-30,1750,textStr);
else
    text(-60,6500,textStr);
end

if dataNet.lmType < 4
    title('Matlab LM Neural Network Training Algorithm');
else
    title('pyrenn LM Neural Network Training Algorithm');
end

end