function[dataNet] = dataGen(dataNet)
% Builds the training and test data sets based on a quadratic curve of
% Y = X * X.
% There are three data set types available (the option is set in mn.m):
% small, medium, and large.
%
% dataGen = data generation for training and testing of a Neural Network

% Load the plot variable option for displaying the plot of raw data.
dPlot           = dataNet.dPlot;
testDataSize    = dataNet.testDataSize;

%**************************************************************************
% INPUT & OUTPUT TRAINING SETS

% Generate raw training x-axis input data
x = [-12, -9, -7, -6, -4, -2, 0, 2, 4, 5, 6, 7, 9, 12];

% Determine the size of the x-axis array.
xSize = size(x);
% Declare and size the y-axis output array.
y = zeros(1,xSize(2));

% Generate the y-axis output for the given x training data (array).
for i = 1: xSize(2)
   y(i) = x(i) * x(i);
end

P = x;
Y = y;
%**************************************************************************


%**************************************************************************
% INPUT & OUTPUT TEST SET
%---------------------------------------------------------------------------
% Generate INPUT raw test data

% SMALL test x-axis input data set
if testDataSize == 1
    xt = [-16, -15, -14, -13, -11, -10, -8, -5, -1, 1, 5, 8, 10, 11, ...
                                                               13, 14, 15, 16];
% MEDIUM test x-axis input data set
elseif testDataSize == 2
    xt = [-25, -22.5, -20, -18, -16, -15, -14, -13, -11, -10, -8, -5, -1, 1, 5, ...
            8, 10, 11, 13, 14, 15, 16, 18, 20, 22.5, 25];

% MEDIUM test x-axis input data set
elseif testDataSize == 3
    xt = [-50, -45, -40, -35, -30, -25, -20 -16, -15, -14, -13, -11, -10, -8, -5, -1, 1, 5, ...
            8, 10, 11, 13, 14, 15, 16, 20, 25, 30, 35, 40, 45, 50];

% LARGE test x-axis input data set
else
    xt = [-90, 80, -70, -60, -50, -30, -20 -16, -15, -14, -13, -11, ...
         -10, -8, -5, -1, 1, 5, 8, 10, 11, 13, 14, 15, 16, 20, 30, 50, ...
         60, 70, 80, 90];
end

% Determine the size of the x-axis INPUT test array.
xSize = size(xt);
% Declare and size the y-axis OUTPUT array.
yt = zeros(1,xSize(2));

% Generate the y-axis OUTPUT for the given INPUT x-axis test data (array).
for i = 1: xSize(2)
   yt(i) = xt(i) * xt(i);
end

% x-axis INPUT data set
Ptest = xt;
% y-axis OUTPUT data set
Ytest = yt;
%**************************************************************************


%---------------------------------------------------------------------------
% Plot the training & test input and output data sets if the option is set.

% Set min and max values for plotting purposes.
minX = min(xt) - 2;
maxX = max(xt) + 2;
minY = min(yt) - 10;
maxY = max(yt) + 10;

if dPlot == 1
    
    % Set the reference curve x-axis input.
	xref = min(xt) : 0.5 : max(xt);
    % Determine the size of reference curve x-axis input array.
    xSize = size(xref);
   
    % Generate the y-axis output for the given reference 
    % x-axis data (array).
    for i = 1: xSize(2)
        yref(i) = xref(i) * xref(i);
    end
   
    %---------------------------------------------------------
    figure(1)
    % Plot the training data.
	plot(x,y,'b-');
	axis([ -14 14 -1 150 ]);
	grid on;
	xlabel('X');
    ylabel('Y');
    legend('Quadratic Function "Curve"');
    
	%---------------------------------------------------------
	figure(2)
    % Plot the test data.
    plot(x,y,'b*',xt,yt,'r*',xref,yref,'k-');
	axis([ minX maxX minY maxY ]);
	grid on;
	xlabel('X');
    ylabel('Y');
    legend('Training Data','Test Data','Reference Curve');

    pause;
   
    close all;
   
end

% Load pertinent arrays to the data structure.
dataNet.x		= x;    % Training input data
dataNet.y		= y;    % Training output data
dataNet.xt		= xt;   % Test input data
dataNet.yt		= yt;   % Test output data

dataNet.P       = P;
dataNet.Y       = Y;
dataNet.Ptest   = Ptest;
dataNet.Ytest   = Ytest;

