% Calculate Error for NN based on data
% 
% Args:
%     net:	neural network
%     data: 	Training Data
% Returns:
%     E:		Mean squared Error of the Neural Network compared to Training data

function [E] = calc_error(net,data) 


P=data.P;   %Eingangsdaten
Y=data.Y;   %Ausgangsdaten des Systems
a=data.a;   %Schichtausgnge
q0=data.q0; %Ab q0.tem Trainingsdatum Ausgnge berechnen


M = net.M;      %Anzahl der Schichten des NN
layers=net.layers;    %Aufbau des Netzes
dI=net.dI;      %Verzgerung der Eingnge
dL=net.dL;      %Verzgerung zwischen den Schichten
L_f=net.L_f;    %Vorwrtsverbindungen der Schichten

I=net.I;        %Eingnge in die Schichten


% Gesamtgewichtvektor in Gewichtmatrizen/ Vektoren umwandeln
[IW,LW,b]=w2Wb(net);

%% 1. Vorwrtspropagieren:
[Y_NN,n,a] = NNOut_(P,net,IW,LW,b,a,q0);     %Ausgnge, Summenausgnge und Schichtausgnge des NN berechnen


%% 2. Kostenfunktion berechnen:
Y_delta=Y-Y_NN;   %Fehlermatrix: Fehler des NN-Ausgangs bezglich des Systemausgangs fr jeden Datenpunkt
e=reshape(Y_delta,[],1);    %Fehlervektor (untereinander) [y_delta1_ZP1;y_delta2_ZP1;...;y_delta1_ZPX;y_delta2_ZPX]
E=e'*e; %Kostenfunktion: Summierter Quadratischer Fehler