% Netzaufbau mit Gewichten und Verzgerungen erstellen und wichtige ngen
% erstellen

function [net]=CreateNN(nn,dIn,dIntern,dOut)

% dIn: Zelle fr jeden Eingang mit Vektor der Verzgerungen
if ~exist('dIn', 'var')
    dIn = [0];
end
% dIntern: Vektor mit den Verzgerungen der Internen Schichten (AuerSM -> S1)
if ~exist('dIntern', 'var')
    dIntern = [];
end
% dOut: Zelle fr jeden Ausgang mit Vektor der Verzgerungen zur Schicht S1
if ~exist('dOut', 'var')
    dOut = [];
end





% NN=[P S1 S2 .. SM] Aufbau des Netzes( P steht fr Anzahl der
    % Eingnge, Sm fr die Anzahl der ronen von Schicht m

    
  
net.nn=nn; %Gesamtaufbau mit Eingngen
net.delay.In=dIn;    %Eingansverzgerung
net.delay.Intern=dIntern;    %Interne Verzgerungen
net.delay.Out=dOut;    %Ausgangsverzgerungen

net.M=length(nn)-1;        %Anzahl der Schichten des Neuronalen Netzes
net.layers=nn(2:end);      % Aufbau des NN ohne Eingangsmatrix [S1 S2...SM]
net.dmax=max([net.delay.In,net.delay.Intern,net.delay.Out]); %Maximale Verzgerung innerhalb des NN


[net]=w_Create(net); %Gesamtgewichtsvektor Net.w_0 erzeugen sowie wichtige Mengen erzeugen

net.N=length(net.w_0); %Anzahl der Gewichte
net.w=net.w_0; %Zu Otimierender Gesamtgewichtsvektor Net.w_k ist zu Beginn der Startvektor Net.w_0

end