function performanceLM

clear;
close all;
clc;

%**************************************************************************
%**************************************************************************
% Data Set #1
%**************************************************************************

dSet1Matlab = zeros(1,3);
dSet1Pyrenn = zeros(1,3);

% 1-4-1
errorsMatlab_1 = [1443.2, 2373.4, 1287.5, 254.8, 748.4, 283.6, 18318.3, ...
                                                      638.3, 109.9, 346.0];
errorsPyrenn_1 = [0.5, 3.5, 0.5, 0.5, 0.5, 0.5, 0.5, 3.3, 0.5, 0.5];

errorsMatlab_1 = sort(errorsMatlab_1);
errorsPyrenn_1 = sort(errorsPyrenn_1);

figure(1);
semilogy(1:10, errorsMatlab_1, 'r-');
hold on;
semilogy(1:10, errorsPyrenn_1, 'b-');
grid on;
ylim([0.5 1.0e5]);
xlabel('Trained Neural Network Number');
ylabel('Total Neural Network Testing Set Error');
legend('Matlab','Pyrenn');
title('Data Set #1 => Neural Architecture: 1 - 4 - 1');

avgErr_Matlab_1 = mean(errorsMatlab_1);
avgErr_Pyrenn_1 = mean(errorsPyrenn_1);

dSet1Matlab(1) = avgErr_Matlab_1;
dSet1Pyrenn(1) = avgErr_Pyrenn_1;

%--------------------------------------------------------------------------

% 1-4-4-1
errorsMatlab_2 = [1020.6, 1365.5, 1954.5, 963.3, 379.4, 404.8, 542.4, ...
                                                     1063.1, 541.1, 554.0];
errorsPyrenn_2 = [9.7, 2.6, 8.4, 4.4, 5.5, 5.2, 16.5, 2.0, 19.8, 5.4];

errorsMatlab_2 = sort(errorsMatlab_2);
errorsPyrenn_2 = sort(errorsPyrenn_2);

figure(2);
semilogy(1:10, errorsMatlab_2, 'r-');
hold on;
semilogy(1:10, errorsPyrenn_2, 'b-');
grid on;
ylim([0.5 1.0e5]);
xlabel('Trained Neural Network Number');
ylabel('Total Neural Network Testing Set Error');
legend('Matlab','Pyrenn');
title('Data Set #1 => Neural Architecture: 1 - 4 - 4 - 1');

avgErr_Matlab_2 = mean(errorsMatlab_2);
avgErr_Pyrenn_2 = mean(errorsPyrenn_2);

dSet1Matlab(2) = avgErr_Matlab_2;
dSet1Pyrenn(2) = avgErr_Pyrenn_2;

%--------------------------------------------------------------------------

% 1-8-8-1
errorsMatlab_3 = [509.8, 891.3, 1390.2, 469.1, 581.1, 622.9, 1380.5, ...
                                                    1707.6, 909.6, 1579.6];
errorsPyrenn_3 = [9.5, 6.1, 24.9, 4.5, 8.1, 4.7, 5.9, 5.6, 4.8, 9.0];

errorsMatlab_3 = sort(errorsMatlab_3);
errorsPyrenn_3 = sort(errorsPyrenn_3);

figure(3);
semilogy(1:10, errorsMatlab_3, 'r-');
hold on;
semilogy(1:10, errorsPyrenn_3, 'b-');
grid on;
ylim([0.5 1.0e5]);
xlabel('Trained Neural Network Number');
ylabel('Total Neural Network Testing Set Error');
legend('Matlab','Pyrenn');
title('Data Set #1 => Neural Architecture: 1 - 8 - 8 - 1');

avgErr_Matlab_3 = mean(errorsMatlab_3);
avgErr_Pyrenn_3 = mean(errorsPyrenn_3);

dSet1Matlab(3) = avgErr_Matlab_3;
dSet1Pyrenn(3) = avgErr_Pyrenn_3;

%--------------------------------------------------------------------------

trainTimeMatlab_1 = [21.7, 3.4, 2.9];
trainTimePyrenn_1 = [26.3, 20.5, 40.6];

trainTimeMatlab_1 = sort(trainTimeMatlab_1);
trainTimePyrenn_1 = sort(trainTimePyrenn_1);

figure(50);
plot(1:3,trainTimeMatlab_1,'r-');
hold on;
plot(1:3,trainTimePyrenn_1,'b-');
grid on;
axis([1 3 0 60]);
xticks([1 2 3]);
xlabel('Neural Network Architecture');
ylabel('Training Time (seconds)');
legend('Matlab','Pyrenn');
title('Training Times for Data Set #1');

%**************************************************************************
%**************************************************************************
% Data Set #2
%**************************************************************************

dSet2Matlab = zeros(1,3);
dSet2Pyrenn = zeros(1,3);

% 1-4-1
errorsMatlab_4 = [1515.1, 2343.3, 32.2, 4012.6, 17.8, 1986.1, 82.7, ...
                                                   3793.2, 2948.7, 5403.8];
errorsPyrenn_4 = [12.6, 315.3, 12.6, 12.6, 12.6, 161.4, 12.6, 12.6, ...
                                                              12.6, 188.9];

errorsMatlab_4 = sort(errorsMatlab_4);
errorsPyrenn_4 = sort(errorsPyrenn_4);

figure(4);
semilogy(1:10, errorsMatlab_4, 'r-');
hold on;
semilogy(1:10, errorsPyrenn_4, 'b-');
grid on;
ylim([0.5 1.0e5]);
xlabel('Trained Neural Network Number');
ylabel('Total Neural Network Testing Set Error');
legend('Matlab','Pyrenn');
title('Data Set #2 => Neural Architecture: 1 - 4 - 1');

avgErr_Matlab_4 = mean(errorsMatlab_4);
avgErr_Pyrenn_4 = mean(errorsPyrenn_4);

dSet2Matlab(1) = avgErr_Matlab_4;
dSet2Pyrenn(1) = avgErr_Pyrenn_4;

%--------------------------------------------------------------------------

% 1-4-4-1
errorsMatlab_5 = [4076.9, 4769.4, 3085.2, 3158.1, 4399.3, 4227.1, ...
                                           3587.2, 3806.3, 2901.0, 3354.7];
errorsPyrenn_5 = [283.7, 648.9, 512.1, 470.9, 351.2, 281.3, 302.7, ...
                                                      772.9, 413.3, 308.6];

errorsMatlab_5 = sort(errorsMatlab_5);
errorsPyrenn_5 = sort(errorsPyrenn_5);

figure(5);
semilogy(1:10, errorsMatlab_5, 'r-');
hold on;
semilogy(1:10, errorsPyrenn_5, 'b-');
grid on;
ylim([0.5 1.0e5]);
xlabel('Trained Neural Network Number');
ylabel('Total Neural Network Testing Set Error');
legend('Matlab','Pyrenn');
title('Data Set #2 => Neural Architecture: 1 - 4 - 4 - 1');

avgErr_Matlab_5 = mean(errorsMatlab_5);
avgErr_Pyrenn_5 = mean(errorsPyrenn_5);

dSet2Matlab(2) = avgErr_Matlab_5;
dSet2Pyrenn(2) = avgErr_Pyrenn_5;

%--------------------------------------------------------------------------

% 1-8-8-1
errorsMatlab_6 = [4277.0, 3303.6, 4484.6, 3495.5, 4520.0, 3666.5, ...
                                           3099.1, 4772.5, 4563.0, 2784.2];
errorsPyrenn_6 = [769.6, 470.2, 544.7, 339.8, 692.9, 449.6, 611.5, ...
                                                      559.3, 462.1, 408.7];

errorsMatlab_6 = sort(errorsMatlab_6);
errorsPyrenn_6 = sort(errorsPyrenn_6);

figure(6);
semilogy(1:10, errorsMatlab_6, 'r-');
hold on;
semilogy(1:10, errorsPyrenn_6, 'b-');
grid on;
ylim([0.5 1.0e5]);
xlabel('Trained Neural Network Number');
ylabel('Total Neural Network Testing Set Error');
legend('Matlab','Pyrenn');
title('Data Set #2 => Neural Architecture: 1 - 8 - 8 - 1');

avgErr_Matlab_6 = mean(errorsMatlab_6);
avgErr_Pyrenn_6 = mean(errorsPyrenn_6);

dSet2Matlab(3) = avgErr_Matlab_6;
dSet2Pyrenn(3) = avgErr_Pyrenn_6;

%--------------------------------------------------------------------------

trainTimeMatlab_2 = [17.8, 2.7, 3.1];
trainTimePyrenn_2 = [23.2, 22.2, 20.1];

trainTimeMatlab_2 = sort(trainTimeMatlab_2);
trainTimePyrenn_2 = sort(trainTimePyrenn_2);

figure(51);
plot(1:3,trainTimeMatlab_2,'r-');
hold on;
plot(1:3,trainTimePyrenn_2,'b-');
grid on;
axis([1 3 0 60]);
xticks([1 2 3]);
xlabel('Neural Network Architecture');
ylabel('Training Time (seconds)');
legend('Matlab','Pyrenn');
title('Training Times for Data Set #2');

%**************************************************************************
%**************************************************************************
% Data Set #3
%**************************************************************************

dSet3Matlab = zeros(1,2);
dSet3Pyrenn = zeros(1,2);

% 1-4-1
errorsMatlab_7 = [16789.2, 16407.8, 12689.8, 15947.9, 7624.7, 1445.2,  ...
                                       12090.7, 19692.8, 15507.6, 14822.1];
errorsPyrenn_7 = [920.0, 920.0, 920.0, 919.9, 4353.4, 7412.2, 920.0, ...
                                                      919.9, 920.0, 919.9];

errorsMatlab_7 = sort(errorsMatlab_7);
errorsPyrenn_7 = sort(errorsPyrenn_7);

figure(7);
semilogy(1:10, errorsMatlab_7, 'r-');
hold on;
semilogy(1:10, errorsPyrenn_7, 'b-');
grid on;
ylim([0.5 1.0e5]);
xlabel('Trained Neural Network Number');
ylabel('Total Neural Network Testing Set Error');
legend('Matlab','Pyrenn');
title('Data Set #3 => Neural Architecture: 1 - 4 - 1');

avgErr_Matlab_7 = mean(errorsMatlab_7);
avgErr_Pyrenn_7 = mean(errorsPyrenn_7);

dSet3Matlab(1) = avgErr_Matlab_7;
dSet3Pyrenn(1) = avgErr_Pyrenn_7;

%--------------------------------------------------------------------------

% 1-8-8-1
errorsMatlab_8 = [17004.4, 16776.2, 18183.6, 17841.0, 18674.2, 17062.0, ...
                                       17861.2, 19164.3, 17148.0, 17798.8];
errorsPyrenn_8 = [10605.9, 9032.9, 7875.8, 10066.7, 11756.0, 12540.9, ...
                                        9148.1, 11824.6, 10286.2, 11164.6];

errorsMatlab_8 = sort(errorsMatlab_8);
errorsPyrenn_8 = sort(errorsPyrenn_8);

figure(8);
semilogy(1:10, errorsMatlab_8, 'r-');
hold on;
semilogy(1:10, errorsPyrenn_8, 'b-');
grid on;
ylim([0.5 1.0e5]);
xlabel('Trained Neural Network Number');
ylabel('Total Neural Network Testing Set Error');
legend('Matlab','Pyrenn');
title('Data Set #3 => Neural Architecture: 1 - 8 - 8 - 1');

avgErr_Matlab_8 = mean(errorsMatlab_8);
avgErr_Pyrenn_8 = mean(errorsPyrenn_8);

dSet3Matlab(2) = avgErr_Matlab_8;
dSet3Pyrenn(2) = avgErr_Pyrenn_8;

%--------------------------------------------------------------------------

trainTimeMatlab_3 = [57.0, 2.8];
trainTimePyrenn_3 = [24.5, 26.4];

trainTimeMatlab_3 = sort(trainTimeMatlab_3);
trainTimePyrenn_3 = sort(trainTimePyrenn_3);

figure(52);
plot(1:2,trainTimeMatlab_3,'r-');
hold on;
plot(1:2,trainTimePyrenn_3,'b-');
grid on;
axis([1 2 0 60]);
xticks([1 2]);
xlabel('Neural Network Architecture');
ylabel('Training Time (seconds)');
legend('Matlab','Pyrenn');
title('Training Times for Data Set #3');

%==========================================================================

% Plot the summary performance curves.

% Data Set #1
figure(60);
semilogy(1:3,dSet1Matlab,'r-');
hold on;
semilogy(1:3,dSet1Pyrenn,'b-');
grid on;
xticks([1 2 3]);
ylim([0.5 1.0e5]);
xlabel('Neural Network Architecture Types');
ylabel('Average Test Error for 10 Neural Networks'); 
legend('Matlab LM','Pyrenn LM');
title('Test Case #1');
%--------------------------------------------------------------------------

% Data Set #2

figure(61);
semilogy(1:3,dSet2Matlab,'r-');
hold on;
semilogy(1:3,dSet2Pyrenn,'b-');
grid on;
xticks([1 2 3]);
ylim([0.5 1.0e5]);
xlabel('Neural Network Architecture Types');
ylabel('Average Test Error for 10 Neural Networks'); 
legend('Matlab LM','Pyrenn LM');
title('Test Case #2');
%--------------------------------------------------------------------------

% Data Set #3

figure(62);
x = [1 3];
semilogy(x,dSet3Matlab,'r-');
hold on;
semilogy(x,dSet3Pyrenn,'b-');
grid on;
xticks([1 3]);
ylim([0.5 1.0e5]);
xlabel('Neural Network Architecture Types');
ylabel('Average Test Error for 10 Neural Networks'); 
legend('Matlab LM','Pyrenn LM');
title('Test Case #3');
%--------------------------------------------------------------------------

end