function mn
% Main function to build, train, and test Neural Networks using the 
% Levenberg-Marquardt optimization algorithm.  There are two options:
% 1) Matlab's LM algorithm, or 2) Pyrenn's LM algorithm.


% Close out all work from any previous sessions.
clear;
clear tstnet trnet train_LM scaleNet dataGen trainNewffNet trainFFNet ...
        trainPyrennNet trainlm newff ... 
        CreateNN loadNN NNOut RTRL saveNN w_Create w2Wb Wb2w;
%close all;
clc;

addpath pyrennFunc;
addpath testFunc;

%*****************************************************************
%*****************************************************************
% START - USER PARAMETERS

% 1 = Matlab LM (old - scaled data)
% 2 = Matlab LM (old - UNscaled data)
% 3 = Matlab LM (new)
% 4 = Pyrenn LM
lmType = 4;

% 1 = small
% 2 = medium
% 3 = large
testDataSize = 1;

% Data function --------------------------------------------------
% 1 = show the function curve 
% 0 = do NOT show the function curve
dPlot = 0;
  
% Matlab LM Set-up -----------------------------------------------
% Scaling factors 
% Input min / max values
sIn = 0.8;
% Output min / max values
sOut = 0.8;
% Review only the scale factor plots
% 1 = show the scaled function and data sets.
% 0 = do NOT show the scaled function and data sets.
sPlot = 0;
% Neural Network architecture ------------------------------------

% Both Matlab and pyrenn LM --------------------------------------
%
anet = 4;
% Number of Neural Networks to train and test
% Select the Neural Network architecture.
% anet = 1 => [8,8,8,1]		3 hidden layers, 8 neurons each, 1 output														
% anet = 2 => [8,8,1]		2 hidden layers, 8 neurons each, 1 output																
% anet = 3 => [4,4,1]		2 hidden layers, 4 neurons each, 1 output															
% anet = 4 => [4,1]			1 hidden layer,  4 neurons, 	 1 output														
% anet = 5 => [2,1]			1 hidden layer,  2 neurons,      1 output														

% Total number of allowed optimization iterations
epoch = 10000;
% Maximum allowable optimization error
optErr = 1e-9; % No lower than 1e-10 for pyrenn LM.

numPass = 10;

setYPlotLimits  = false;
yPlotLimits     = [-100, 2500];
% Matlab output activation function
actFunc = 'purelin';
%actFunc = 'poslin';

% END - USER PARAMETERS
%*****************************************************************
%*****************************************************************

% Load user parameters into a data structure.
dataNet.anet            = anet;
dataNet.sIn             = sIn;
dataNet.sOut            = sOut;
dataNet.sPlot           = sPlot;
dataNet.dPlot           = dPlot;
dataNet.testDataSize    = testDataSize;
dataNet.epoch           = epoch;
dataNet.optErr          = optErr;
dataNet.setYPlotLimits  = setYPlotLimits;
dataNet.yPlotLimits     = yPlotLimits;
dataNet.actFunc         = actFunc;

dataNet.lmType          = lmType;

% Don't display the "Warning: NEWFF used in an obsolete way." message.
if lmType <= 2
    warning('off');
end

% Generate the raw training and test sets.  
%
% Note: If dPlot = 1, then only the
% curve will be plotted (two plots) for learning / debug purposes - there
% will be not training of Neural Networks or testing.
[dataNet] = dataGen(dataNet);

% 
if dPlot ~= 1
	% Scale the training and test data the Neural Network.
	[dataNet] = scaleNet(dataNet);
end

if sPlot ~= 1 && dPlot ~= 1
   
    %------------------------------------------------------------
    % Train and test multiple Neural Networks.
   
    % Do not display the test results at this point.
    dataNet.testDisp = 0;
    % Record the starting cpu time.
    tt = cputime;

    % numPass = number of Neural Networks to build, train, and teste.
    for i = 1: numPass
      
        % Build and train the Neural Network.
		[dataNet] = trnet(i,dataNet);
		% Test the Neural Network against the tet data set.
		[dataNet] = tstnet(i,dataNet); 

    end
   
    % Record the elapsed training/testing time for all Neural Networks.
    total_time = cputime - tt;
   
    fprintf(1,'Training / Testing took %5.1f seconds\n',total_time);
    dataNet.total_time = total_time;

    %------------------------------------------------------------
	% Find the Neural Network with lowest output error.
   
    % Set a really high value for error initially 
    % (this is the reference to start).
	minErr = 1e20;
   
    % Look at the error for each Neural Network and 
    % save the lowest error value.
    for i = 1: numPass
        
        % Extract the error for this particular Neural Network 
        % error in the array.
        err = abs(dataNet.err(i));
        % If the error is less then the current minimum error then 
        % replace the minimum errror with this value and save 
        % the index number.
        if err < minErr
            minErr = err;
            index = i;
        end
   
    end  

    %------------------------------------------------------------
    % Display the results of the best Neural Network.
    dataNet.testDisp = 1;
    [dataNet] = tstnet(index,dataNet);
    
end

% The functions must be deleted or else stored data can affect a 
% new run of this function.
clear tstnet trnet train_LM scaleNet dataGen trainNewffNet trainFFNet ...
        trainPyrennNet trainlm newff ... 
        CreateNN loadNN NNOut RTRL saveNN w_Create w2Wb Wb2w;

end

