
package earthproj;

import java.awt.Color;

/**
 * This is the driver for the project.  It's purpose is to : 1) build the 
 * trajectory and radar objects, 2) build and set up the Earth panels and mount 
 * the Earth model, and 3) propagate the trajectory and radar objects visibly 
 * in the Earth model.
 * 
 * @author mikescodeprojects
 */
public class EarthProj 
{
    /**
     * 
     * 
     * @param args
     */
    public static void main(String[] args)
    {
        //----------------------------------------------------------------------
        // DECLARE VARIABLES
        
        // Status for activating or disabling the UTM grid layer.
        boolean showUTMGrid;
        // Status for activating or disabling the atmosphere layer.
        boolean showAtmosphere;
        // Status for activating or disabling the stars layer.
        boolean showStars;
        // Status for activating or disabling the user-specified clip distance
        // values.
        boolean clipDistanceStatus;
        // User-specified "near" and "far" clip distances.
        double nearClipDistanceVal;
        double farClipDistanceVal;
        // Trajectory object #1 launch / take-off coordinates.
        double lonAC_1;
        double latAC_1;
        double altAC_1;
        // Trajectory object #1 trajectory properties.
        Color colorTraj_1;
        double lineWidthTraj_1;
        int trajType_1;
        // Trajectory object #2 launch / take-off coordinates.
        double lonAC_2;
        double latAC_2;
        double altAC_2;
        // Trajectory object #2 trajectory properties.
        Color colorTraj_2;
        double lineWidthTraj_2;
        int trajType_2;
        // Earth model user-specified observer coordinates.
        double latView;
        double lonView;
        double altView;
        // Radar object #1 base station coordinates.
        double latRadar_1;
        double lonRadar_1;
        double altRadar_1;
        // Radar object #2 base station coordinates.
        double latRadar_2;
        double lonRadar_2;
        double altRadar_2;
        // User-specified simulation time delay value.
        int timeDelay;
        double resDial;
        
        //----------------------------------------------------------------------
        // BUILD TRAJECTORY OBJECTS & TRAJECTORY OBJECTS ARRAY
        //
        // Declare-Instantiate-Initialize (DII) first trajectory object.
        TrajectoryObjects aircraft_1 = new TrajectoryObjects();
        // Declare-Instantiate-Initialize (DII) second trajectory object.
        TrajectoryObjects aircraft_2 = new TrajectoryObjects();
        // Build an array to hold the trajectory objects.
        TrajectoryObjects[] to = new TrajectoryObjects[2];
        //----------------------------------------------------------------------

        
        //----------------------------------------------------------------------
        // BUILD RADAR OBJECTS & RADAR OBJECTS ARRAY
        //
        // Declare-Instantiate-Initialize (DII) first radar object.
        RadarObjects ro_1 = new RadarObjects();
        // Declare-Instantiate-Initialize (DII) second radar object.
        RadarObjects ro_2 = new RadarObjects();
        // Build an array to hold the radar objects.
        RadarObjects[] ro = new RadarObjects[2];
        //----------------------------------------------------------------------

        
        //**********************************************************************
        // START USER INPUTS

        //-----------------------------------------------
        // EARTH MODEL PARAMETERS
        //
        // Set time delay.
        timeDelay           = 0;
        // Trajectory step resolution
        // High number (e.g. 10.0) = high resolution with very small steps.
        // Low number (e.g. 1.0) = low resolution with very large steps.
        resDial             = 1.0;
        // Show the UTM grid layer.
        showUTMGrid         = false;
        // Show the atmosphere layer.
        showAtmosphere      = false;
        // Show the stars layer.
        showStars           = false;
        
        // Set user-specified clip distance control.
        clipDistanceStatus  = true;
        // Set user-specified clip distance boundaries.
        nearClipDistanceVal = 1_000_000.0;
        farClipDistanceVal  = 1_000_000_000.0;
        
        // Set observer view coordinates.
        latView             = 38.0;
        lonView             = -86.0;
        altView             = 3_000_000.0;

        //-----------------------------------------------
        // TRAJECTORY OBJECT PARAMETERS
        //
        // Take-off points for aircraft_1
        lonAC_1              = -50.143936;
        latAC_1              = -11.779236;
        altAC_1              = 0.0;
        // Trajectory properties for aircraft_1
        colorTraj_1         = Color.RED;
        lineWidthTraj_1     = 3.0;
        // Trajectory path type
        trajType_1          = 1;
        
        // Take-off points for aircraft_2
        lonAC_2              = -60.143936;
        latAC_2              = -11.779236;
        altAC_2              = 0.0;
        // Trajectory properties for aircraft_2
        colorTraj_2         = Color.GREEN;
        lineWidthTraj_2     = 3.0;
        // Trajectory path type
        trajType_2          = 2;
        
        //-----------------------------------------------
        // RADAR OBJECT PARAMETERS
        //
        // Base coordinates for 1st radar station
        lonRadar_1            = -40.21;
        latRadar_1            = -5.5;
        altRadar_1            = 0.0;
        // Base coordinates for 2nd radar station
        lonRadar_2            = 8.0;
        latRadar_2            = 24.0;
        altRadar_2            = 0.0;

        // END USER INPUTS
        //**********************************************************************

        
        //----------------------------------------------------------------------
        // CONFIGURE TRAJECTORY OBJECTS and LOAD THE TRAJECTORY OBJECTS ARRAY
        //
        // Configure the first trajectory object as a Path type object.
        aircraft_1.setPathObject(colorTraj_1, lineWidthTraj_1);
        // Configure the 2nd trajectory object as a Polyline type object.
        aircraft_2.setPolylineObject(colorTraj_2, lineWidthTraj_2);
        
        // ??
        aircraft_1.setTrajResolution(resDial);
        // ??
        aircraft_2.setTrajResolution(resDial);
        
        // Load Trajectory Object (aircraft) take-off coordinates.
        aircraft_1.setGeoInit(latAC_1,lonAC_1,altAC_1);
        aircraft_2.setGeoInit(latAC_2,lonAC_2,altAC_2);
        
        // Trajectory Object #1 - use custom trajectory #1
        if( trajType_1 == 1)
        {
            aircraft_1.setTrajTypeOne();
        }
        // Trajectory Object #1 - use custom trajectory #2
        else if( trajType_1 == 2)
        {
            aircraft_1.setTrajTypeTwo();
        }

        // Trajectory Object #2 - use custom trajectory #1
        if( trajType_2 == 1)
        {
            aircraft_2.setTrajTypeOne();
        }
        // Trajectory Object #2 - use custom trajectory #2
        else if( trajType_2 == 2)
        {
            aircraft_2.setTrajTypeTwo();
        }

        // Load the trajectory objects array with both aircraft objects.
        to[0] = aircraft_1;
        to[1] = aircraft_2;
        //----------------------------------------------------------------------


        //----------------------------------------------------------------------
        // CONFIGURE RADAR OBJECTS and LOAD THE RADAR OBJECTS ARRAY
        //
        // Load the trajectory object for the first radar object to track.
        ro_1.loadTrajectoryObject(aircraft_2);
        // Load base coordinates for radar station.
        ro_1.setBaseCoord(latRadar_1,lonRadar_1,altRadar_1);
        // Load the trajectory object for the second radar object to track.
        ro_2.loadTrajectoryObject(aircraft_1);
        // Load base coordinates for radar station.
        ro_2.setBaseCoord(latRadar_2,lonRadar_2,altRadar_2);
        // Load the trajectory array with both radar objects.
        ro[0] = ro_1;
        ro[1] = ro_2;
        //----------------------------------------------------------------------


        //----------------------------------------------------------------------
        // CONFIGURE SCENARIO SETTINGS
        //
        // This object holds all of the initial settings for running the
        // scenario - Earth layers, view vector, etc.
        ScenarioSettings ss = new ScenarioSettings();
        // Set the initial view parameters.
        double[] vect = new double[3];
        vect[0] = latView;
        vect[1] = lonView;
        vect[2] = altView;
        // Load to the scenario settings object.
        ss.setViewSettings(vect);
        
        // Set the switch value for the UTM grid layer.
        ss.setUTMGridOption(showUTMGrid);
        // Set the switch value for the Atmosphere layer.
        ss.setATMLayerOption(showAtmosphere);
        // Set the switch value for the Stars layer.
        ss.setStarsLayerOption(showStars);
        // Load the time delay value in the ScenarioSettings object.
        ss.setTimeDelay(timeDelay);
        // If the user is controlling the clip distance - load the status and values
        // into the ScenarioSettings object.
        if( clipDistanceStatus )
        {
            ss.setClipDistances(clipDistanceStatus);
            ss.setClipDistances(nearClipDistanceVal, farClipDistanceVal);
        }
        
        // Load Trajectory objects array into the ScenarioSettings object.
        ss.loadTrajectoryObjects(to);
        // Load radar objects array into the ScenarioSettings object.
        ss.loadRadarModels(ro);
        //----------------------------------------------------------------------
        

        //----------------------------------------------------------------------
        // CONFIGURE EARTH MODEL
        //
        // Build EarthView object - note that the ScenarioSettings object 
        // is loaded through the EarthView constructor.
        EarthView ev = new EarthView(ss);
        // Configure the Earth model layers.
        ev.configureEarthLayers();
        //----------------------------------------------------------------------

        
        //----------------------------------------------------------------------
        // MAIN SIMULATION
        //
        // Run the test trajectory for demo purposes.
        ev.trajSim();
        //----------------------------------------------------------------------
    }

} // end of main class EarthProj
