
package earthproj;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;

/**
 * The purpose of this class to build a JPanel according to the user 
 * specifications.  It is used by class EarthView to build up the Swing 
 * containers which hold the Earth model.
 * 
 * @author mikescodeprojects
 */
public class BuildJPanel
{
    private final JPanel customJPanel;

    /**
     * Build the entire JPanel according to the user specifications in the
     * constructor argument list.
     *
     * @param fl The Flow control numbers
     * @param dim The Dimensions - width by height
     * @param col The RGB Color numbers
     * @param bev If true then set raised beveled appearance
     * @param op If true then set the panel to be "opaque"
     */
    public BuildJPanel(int[] fl, int[] dim, int[] col, boolean bev, boolean op)
    {
        // Build the basic JPanel object.
        customJPanel = new JPanel();
        // Set it to be opaque.
        customJPanel.setOpaque(op);
        // Set the dimensions (in monitor values).
        customJPanel.setMinimumSize(new Dimension(dim[0],dim[1]));
        customJPanel.setPreferredSize(new Dimension(dim[0],dim[1]));
        // Set the background color of the JPanel.
        customJPanel.setBackground(new Color(col[0],col[1],col[2]));

        if(bev)
        {
            // Set a raised beveled appearance using the Border layout.
            customJPanel.setLayout(new BorderLayout());
            customJPanel.setBorder(BorderFactory.
                                        createBevelBorder(BevelBorder.RAISED));
        }
        else
        {
            // Use the Flow (non-beveled) layout.
            customJPanel.setLayout(new FlowLayout(fl[0],fl[1],fl[2]));
        }
    }

    //--------------------------------------------------------------------------
    /**
     * The purpose is return the constructed JPanel - this is used by class
     * EarthView.
     *
     * @return The constructed JPanel with user-specified parameters.
     */
    public JPanel getJPanel()
    {
        return customJPanel;
    }

} // end of class BuildJPanel
