/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.areas;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.symbology.TacticalGraphicUtil;
import gov.nasa.worldwind.symbology.milstd2525.AbstractMilStd2525TacticalGraphic;
import gov.nasa.worldwind.util.Logging;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class AttackByFirePosition
extends AbstractMilStd2525TacticalGraphic {
    public static final double DEFAULT_ARROWHEAD_LENGTH = 0.2;
    public static final Angle DEFAULT_ARROWHEAD_ANGLE = Angle.fromDegrees(70.0);
    public static final double DEFAULT_LEG_LENGTH = 0.25;
    protected Angle arrowAngle = DEFAULT_ARROWHEAD_ANGLE;
    protected double arrowLength = 0.2;
    protected double legLength = 0.25;
    protected Position position1;
    protected Position position2;
    protected Position position3;
    protected Path[] paths;

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-G-OAF--------");
    }

    public AttackByFirePosition(String string) {
        super(string);
    }

    public Angle getArrowAngle() {
        return this.arrowAngle;
    }

    public void setArrowAngle(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle.degrees <= 0.0 || angle.degrees >= 90.0) {
            String string = Logging.getMessage("generic.AngleOutOfRange");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.arrowAngle = angle;
    }

    public double getArrowLength() {
        return this.arrowLength;
    }

    public void setArrowLength(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.arrowLength = d;
    }

    public double getLegLength() {
        return this.arrowLength;
    }

    public void setLegLength(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.legLength = d;
    }

    @Override
    public void setPositions(Iterable<? extends Position> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            Iterator<? extends Position> iterator = iterable.iterator();
            this.position1 = iterator.next();
            this.position2 = iterator.next();
            this.position3 = iterator.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            String string = Logging.getMessage("generic.InsufficientPositions");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.paths = null;
    }

    @Override
    public Iterable<? extends Position> getPositions() {
        return Arrays.asList(this.position1, this.position2, this.position3);
    }

    @Override
    public Position getReferencePosition() {
        return this.position1;
    }

    @Override
    protected void doRenderGraphic(DrawContext drawContext) {
        if (this.paths == null) {
            this.createShapes(drawContext);
        }
        for (Path path : this.paths) {
            path.render(drawContext);
        }
    }

    @Override
    protected void applyDelegateOwner(Object object) {
        if (this.paths == null) {
            return;
        }
        for (Path path : this.paths) {
            path.setDelegateOwner(object);
        }
    }

    protected void createShapes(DrawContext drawContext) {
        this.paths = new Path[3];
        Position position = new Position(LatLon.interpolate(0.5, this.position2, this.position3), 0.0);
        this.paths[0] = this.createPath(Arrays.asList(position, this.position1));
        List<Position> list = this.computeArrowheadPositions(drawContext, position, this.position1);
        this.paths[1] = this.createPath(list);
        list = this.computeBasePositions(drawContext, this.position2, this.position3, this.position1);
        this.paths[2] = this.createPath(list);
    }

    protected List<Position> computeBasePositions(DrawContext drawContext, Position position, Position position2, Position position3) {
        Globe globe = drawContext.getGlobe();
        Vec4 vec4 = globe.computePointFromPosition(position);
        Vec4 vec42 = globe.computePointFromPosition(position2);
        Vec4 vec43 = vec42.subtract3(vec4);
        double d = vec43.getLength3() * this.getLegLength();
        Vec4 vec44 = globe.computeSurfaceNormalAtPoint(vec4);
        Vec4 vec45 = vec43.cross3(vec44);
        Vec4 vec46 = vec43.normalize3().multiply3(d);
        Vec4 vec47 = globe.computePointFromPosition(position3).subtract3(vec4);
        double d2 = vec45.dot3(vec47);
        double d3 = d2 > 0.0 ? -1.0 : 1.0;
        vec45 = vec45.normalize3().multiply3(d * d3);
        Vec4 vec48 = vec4.add3(vec45).subtract3(vec46);
        vec44 = globe.computeSurfaceNormalAtPoint(vec4);
        vec45 = vec43.cross3(vec44);
        vec45 = vec45.normalize3().multiply3(d * d3);
        Vec4 vec49 = vec42.add3(vec45).add3(vec46);
        return TacticalGraphicUtil.asPositionList(globe, vec48, vec4, vec42, vec49);
    }

    protected List<Position> computeArrowheadPositions(DrawContext drawContext, Position position, Position position2) {
        Globe globe = drawContext.getGlobe();
        Vec4 vec4 = globe.computePointFromPosition(position);
        Vec4 vec42 = globe.computePointFromPosition(position2);
        Vec4 vec43 = vec4.subtract3(vec42);
        double d = this.getArrowLength();
        Vec4 vec44 = vec42.add3(vec43.multiply3(d));
        Vec4 vec45 = globe.computeSurfaceNormalAtPoint(vec44);
        double d2 = vec43.getLength3() * d;
        double d3 = d2 * this.getArrowAngle().tanHalfAngle();
        Vec4 vec46 = vec43.cross3(vec45);
        vec46 = vec46.normalize3().multiply3(d3);
        Vec4 vec47 = vec44.add3(vec46);
        Vec4 vec48 = vec44.subtract3(vec46);
        return TacticalGraphicUtil.asPositionList(globe, vec47, vec42, vec48);
    }

    protected Path createPath(List<Position> list) {
        Path path = new Path(list);
        path.setFollowTerrain(true);
        path.setPathType("gov.nasa.worldwind.avkey.GreatCircle");
        path.setAltitudeMode(1);
        path.setDelegateOwner(this.getActiveDelegateOwner());
        path.setAttributes(this.getActiveShapeAttributes());
        return path;
    }
}

