/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.render.Annotation;
import gov.nasa.worldwind.render.AnnotationLayoutManager;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.logging.Level;
import javax.media.opengl.GL;

public abstract class AbstractAnnotationLayout
implements AnnotationLayoutManager {
    protected OGLStackHandler stackHandler = new OGLStackHandler();
    protected PickSupport pickSupport;

    protected AbstractAnnotationLayout() {
    }

    @Override
    public PickSupport getPickSupport() {
        return this.pickSupport;
    }

    @Override
    public void setPickSupport(PickSupport pickSupport) {
        this.pickSupport = pickSupport;
    }

    @Override
    public void beginDrawAnnotations(DrawContext drawContext, Rectangle rectangle) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rectangle == null) {
            String string = Logging.getMessage("nullValue.RectangleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        GL gL = drawContext.getGL();
        this.stackHandler.pushModelview(gL);
    }

    @Override
    public void endDrawAnnotations(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        GL gL = drawContext.getGL();
        this.stackHandler.pop(gL);
    }

    protected Dimension getAnnotationSize(DrawContext drawContext, Annotation annotation) {
        try {
            return annotation.getPreferredSize(drawContext);
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.ExceptionWhileComputingSize", annotation);
            Logging.logger().log(Level.SEVERE, string, exception);
            return null;
        }
    }

    protected void drawAnnotation(DrawContext drawContext, Annotation annotation, int n, int n2, double d, Position position) {
        try {
            if (this.pickSupport != null) {
                annotation.setPickSupport(this.pickSupport);
            }
            annotation.draw(drawContext, n, n2, d, position);
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.ExceptionWhileRenderingAnnotation", annotation);
            Logging.logger().log(Level.SEVERE, string, exception);
        }
    }
}

