/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.poi;

import gov.nasa.worldwind.exception.NoItemException;
import gov.nasa.worldwind.exception.ServiceException;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.util.logging.Level;

public class POIUtils {
    protected static final String DEFAULT_CHARSET_NAME = "UTF-8";

    public static String callService(String string) throws NoItemException, ServiceException {
        String string2;
        int n;
        Object object;
        InputStream inputStream;
        block8: {
            if (string == null || string.length() < 1) {
                return null;
            }
            inputStream = null;
            URL uRL = new URL(string);
            object = uRL.openConnection();
            HttpURLConnection httpURLConnection = (HttpURLConnection)object;
            n = httpURLConnection.getResponseCode();
            string2 = httpURLConnection.getResponseMessage();
            String string3 = httpURLConnection.getContentType();
            if (n != 200) break block8;
            inputStream = ((URLConnection)object).getInputStream();
            ByteBuffer byteBuffer = WWIO.readStreamToBuffer(inputStream);
            String string4 = POIUtils.getCharsetName(string3);
            String string5 = POIUtils.decodeBuffer(byteBuffer, string4);
            WWIO.closeStream(inputStream, string);
            return string5;
        }
        try {
            try {
                if (n == 400) {
                    throw new NoItemException(string2);
                }
                throw new ServiceException(string2);
            }
            catch (MalformedURLException malformedURLException) {
                object = Logging.getMessage("generic.MalformedURL", string);
                Logging.logger().log(Level.SEVERE, (String)object);
                throw new WWRuntimeException((String)object);
            }
            catch (IOException iOException) {
                object = Logging.getMessage("POI.ServiceError", string);
                Logging.logger().log(Level.SEVERE, (String)object);
                throw new ServiceException((String)object);
            }
        }
        catch (Throwable throwable) {
            WWIO.closeStream(inputStream, string);
            throw throwable;
        }
    }

    protected static String decodeBuffer(ByteBuffer byteBuffer, String string) {
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        try {
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray);
        }
    }

    protected static String getCharsetName(String string) {
        String[] stringArray;
        if (string == null || string.toLowerCase().indexOf("charset") == -1) {
            return DEFAULT_CHARSET_NAME;
        }
        for (String string2 : stringArray = string.split(";")) {
            String[] stringArray2;
            if (!string2.toLowerCase().trim().startsWith("charset") || (stringArray2 = string2.split("=")).length <= 1 || stringArray2[1].trim().length() <= 0) continue;
            return stringArray2[1].trim();
        }
        return DEFAULT_CHARSET_NAME;
    }
}

