/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.pick;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.DrawContext;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.media.opengl.GL;

public class PickSupport {
    protected Map<Integer, PickedObject> pickableObjects = new HashMap<Integer, PickedObject>();
    protected int[] minAndMaxColorCodes;

    public void clearPickList() {
        this.getPickableObjects().clear();
        this.minAndMaxColorCodes = null;
    }

    public void addPickableObject(int n, Object object, Position position, boolean bl) {
        this.getPickableObjects().put(n, new PickedObject(n, object, position, bl));
        this.adjustExtremeColorCodes(n);
    }

    public void addPickableObject(int n, Object object, Position position) {
        this.getPickableObjects().put(n, new PickedObject(n, object, position, false));
        this.adjustExtremeColorCodes(n);
    }

    public void addPickableObject(int n, Object object) {
        this.getPickableObjects().put(n, new PickedObject(n, object));
        this.adjustExtremeColorCodes(n);
    }

    public void addPickableObject(PickedObject pickedObject) {
        this.getPickableObjects().put(pickedObject.getColorCode(), pickedObject);
        this.adjustExtremeColorCodes(pickedObject.getColorCode());
    }

    public PickedObject getTopObject(DrawContext drawContext, Point point) {
        if (this.getPickableObjects().isEmpty()) {
            return null;
        }
        int n = this.getTopColor(drawContext, point);
        if (n == 0) {
            return null;
        }
        PickedObject pickedObject = this.getPickableObjects().get(n);
        if (pickedObject == null) {
            return null;
        }
        return pickedObject;
    }

    public PickedObject resolvePick(DrawContext drawContext, Point point, Layer layer) {
        if (this.getPickableObjects().isEmpty()) {
            return null;
        }
        PickedObject pickedObject = null;
        if (point != null) {
            pickedObject = this.doResolvePick(drawContext, point, layer);
        }
        if (drawContext.getPickRectangle() != null && !drawContext.getPickRectangle().isEmpty()) {
            this.doResolvePick(drawContext, drawContext.getPickRectangle(), layer);
        }
        this.clearPickList();
        return pickedObject;
    }

    protected PickedObject doResolvePick(DrawContext drawContext, Point point, Layer layer) {
        PickedObject pickedObject = this.getTopObject(drawContext, point);
        if (pickedObject != null) {
            if (layer != null) {
                pickedObject.setParentLayer(layer);
            }
            drawContext.addPickedObject(pickedObject);
        }
        return pickedObject;
    }

    protected void doResolvePick(DrawContext drawContext, Rectangle rectangle, Layer layer) {
        int[] nArray = drawContext.getPickColorsInRectangle(rectangle, this.minAndMaxColorCodes);
        if (nArray == null || nArray.length == 0) {
            return;
        }
        for (int n : nArray) {
            PickedObject pickedObject;
            if (n == 0 || (pickedObject = this.getPickableObjects().get(n)) == null) continue;
            if (layer != null) {
                pickedObject.setParentLayer(layer);
            }
            drawContext.addObjectInPickRectangle(pickedObject);
        }
    }

    public int getTopColor(DrawContext drawContext, Point point) {
        return point != null ? drawContext.getPickColorAtPoint(point) : 0;
    }

    public void beginPicking(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        gL.glPushAttrib(8193);
        gL.glDisable(3024);
        gL.glDisable(2896);
        gL.glDisable(2912);
        gL.glDisable(3042);
        gL.glDisable(3553);
        if (drawContext.isDeepPickingEnabled()) {
            gL.glDisable(2929);
        }
    }

    public void endPicking(DrawContext drawContext) {
        drawContext.getGL().glPopAttrib();
    }

    protected Map<Integer, PickedObject> getPickableObjects() {
        return this.pickableObjects;
    }

    protected void adjustExtremeColorCodes(int n) {
        if (this.minAndMaxColorCodes == null) {
            this.minAndMaxColorCodes = new int[]{n, n};
        } else {
            if (this.minAndMaxColorCodes[0] > n) {
                this.minAndMaxColorCodes[0] = n;
            }
            if (this.minAndMaxColorCodes[1] < n) {
                this.minAndMaxColorCodes[1] = n;
            }
        }
    }

    public static boolean areSelectionsTheSame(PickedObject pickedObject, PickedObject pickedObject2) {
        return pickedObject != null && pickedObject2 != null && pickedObject.getObject() == pickedObject2.getObject();
    }
}

